/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;

@Beta
public class CopyInputStreamIntoSupplier
implements Function<InputStream, InputSupplier<InputStream>> {
    @Resource
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSupplier<InputStream> apply(InputStream from) {
        if (from == null) {
            return new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return null;
                }
            };
        }
        try {
            InputSupplier inputSupplier = (InputSupplier)InputSupplier.class.cast(ByteStreams.newInputStreamSupplier((byte[])ByteStreams.toByteArray((InputStream)from)));
            return inputSupplier;
        }
        catch (Exception e) {
            this.logger.warn(e, "ignoring problem retrieving credentials", new Object[0]);
            InputSupplier<InputStream> inputSupplier = null;
            return inputSupplier;
        }
        finally {
            Closeables.closeQuietly((Closeable)from);
        }
    }
}

