/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Set;

public class ArtifactDeleteStep
extends BaseDeploymentStep {
    private String targetDirectory;
    private DeployableArtifact artifact;
    private String targetFile;
    private boolean targetDirectoryShared;
    private boolean targetPathSharedSubDirectories;
    private Set<String> deleteAdditionalTargetFiles = Sets.newHashSet();

    public ArtifactDeleteStep() {
    }

    public ArtifactDeleteStep(int order, HostContainer container, DeployableArtifact artifact, String targetDirectory) {
        super(order, container);
        this.artifact = artifact;
        this.targetDirectory = (String)Preconditions.checkNotNull((Object)targetDirectory);
    }

    public ArtifactDeleteStep(int order, HostContainer container, String targetDirectory) {
        this(order, container, null, targetDirectory);
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        if (this.artifact != null) {
            this.deleteArtifact();
        } else {
            this.deleteTargetFile();
        }
        this.deleteAdditionalFiles(this.getDeleteAdditionalTargetFiles());
        return StepExitCode.SUCCESS;
    }

    protected void deleteArtifact() {
        OverthereFile localFile = this.artifact.getFile();
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetDirectory);
        if (localFile.isDirectory()) {
            if (this.targetDirectoryShared) {
                this.deleteRemoteDirectory(localFile, remoteDir);
            } else {
                this.deleteFile(remoteDir);
            }
        } else {
            String name = Strings.nullToEmpty((String)this.targetFile).trim().isEmpty() ? this.artifact.getName() : this.targetFile;
            this.deleteFile(remoteDir.getFile(name));
        }
    }

    private void deleteRemoteDirectory(OverthereFile localFile, OverthereFile remoteDir) {
        for (OverthereFile file : localFile.listFiles()) {
            OverthereFile remoteFile = remoteDir.getFile(file.getName());
            if (this.targetPathSharedSubDirectories && file.isDirectory()) {
                if (remoteFile.exists()) {
                    this.deleteRemoteDirectory(file, remoteFile);
                    if (!remoteFile.listFiles().isEmpty()) continue;
                    this.deleteFile(remoteFile);
                    continue;
                }
                this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + this.getContainer().getHost() + ". Will not perform delete.");
                continue;
            }
            this.deleteFile(remoteFile);
        }
    }

    protected void deleteTargetFile() {
        OverthereFile remoteFile = this.getRemoteConnection().getFile(this.targetDirectory);
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            remoteFile = remoteFile.getFile(this.targetFile);
        }
        this.deleteFile(remoteFile);
    }

    protected void deleteAdditionalFiles(Set<String> files) {
        for (String file : files) {
            OverthereFile remoteFile = this.getRemoteConnection().getFile(file);
            if (remoteFile.exists()) {
                this.getCtx().logOutput("Deleting " + remoteFile.getPath() + " on host " + this.getContainer().getHost());
                remoteFile.deleteRecursively();
                continue;
            }
            this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + this.getContainer().getHost() + ". Will not perform delete.");
        }
    }

    protected void deleteFile(OverthereFile file) {
        this.getCtx().logOutput("Deleting " + file.getPath() + " on host " + this.getContainer().getHost());
        if (file.exists()) {
            file.deleteRecursively();
        } else {
            this.getCtx().logOutput(file.getPath() + " does not exist on host " + this.getContainer().getHost() + ". Will not perform delete.");
        }
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return this.generateDescription();
        }
        return description;
    }

    protected String generateDescription() {
        if (this.artifact != null) {
            return "Delete " + this.artifact.getName() + " from " + this.getContainer().getHost();
        }
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            return "Delete file " + this.targetFile + " from directory " + this.targetDirectory + " on host " + this.getContainer().getHost();
        }
        return "Delete directory " + this.targetDirectory + " from  " + this.getContainer().getHost();
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }

    public Set<String> getDeleteAdditionalTargetFiles() {
        return this.deleteAdditionalTargetFiles;
    }

    public void setDeleteAdditionalTargetFiles(Set<String> deleteAdditionalTargetFiles) {
        this.deleteAdditionalTargetFiles = deleteAdditionalTargetFiles;
    }

    public void setTargetPathSharedSubDirectories(boolean targetPathSharedSubDirectories) {
        this.targetPathSharedSubDirectories = targetPathSharedSubDirectories;
    }
}

