/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;

@Metadata(virtual=true, description="An artifact deployed on a generic container")
public class CopiedArtifact<D extends DeployableArtifact>
extends AbstractDeployedArtifact<D>
implements DerivedArtifact<D> {
    private boolean useDescriptionGeneratedByStep = false;
    private OverthereFile placeholderProcessedFile;
    private Map<String, String> placeholders = Maps.newHashMap();

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    public D getSourceArtifact() {
        return (D)((DeployableArtifact)this.getDeployable());
    }

    public void initFile(PlaceholderReplacer replacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)replacer);
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        ArtifactCopyStep step = new ArtifactCopyStep(this.getCreateOrder(), this.getFile(), (Container)this.getContainer(), this.getTargetDirectory());
        step.setCreateTargetPath(this.isCreateTargetDirectory());
        step.setTargetFileName(this.resolveTargetFileName());
        step.setSourceFileDescription(((DeployableArtifact)this.getDeployable()).getName());
        if (!this.useDescriptionGeneratedByStep) {
            step.setDescription(this.getDescription(this.getCreateVerb()));
        }
        ctx.addStep((DeploymentStep)step);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx) {
        this.executeDestroy(ctx);
        this.executeCreate(ctx);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        ArtifactDeleteStep step = new ArtifactDeleteStep(this.getDestroyOrder(), (Container)this.getContainer(), (DeployableArtifact)this.getDeployable(), this.getTargetDirectory());
        step.setTargetDirectoryShared(this.isTargetDirectoryShared());
        step.setTargetFile(this.resolveTargetFileName());
        if (!this.useDescriptionGeneratedByStep) {
            step.setDescription(this.getDescription(this.getDestroyVerb()));
        }
        ctx.addStep((DeploymentStep)step);
    }

    public void setUseDescriptionGeneratedByStep(boolean useDescriptionGeneratedByStep) {
        this.useDescriptionGeneratedByStep = useDescriptionGeneratedByStep;
    }
}

