package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A template deployed to a generic container")
public class ProcessedTemplate<D extends Deployable> extends AbstractDeployedArtifact<D> {

    @Property(hidden=true, required = true, description = "Classpath to the freemarker template used to generate the content of the final text base artifact.")
    private String template;

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta d) {
	    ProcessedTemplate<D> which = (ProcessedTemplate<D>) d.getDeployed();
	    which._create(ctx);
    }

	private void _create(DeploymentPlanningContext ctx) {
		TemplateArtifactCopyStep step = new TemplateArtifactCopyStep(getCreateOrder(), getContainer(), getDeployedAsFreeMarkerContext() , getTemplate(), getTargetDirectory());
		step.setCreateTargetPath(isCreateTargetDirectory());
		step.setTargetFileName(resolveTargetFileName());
		step.setSourceFileDescription(getDeployable().getName());
		step.setDescription(getDescription(getCreateVerb()));
		ctx.addStep(step);
	}

	@Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        executeDestroy(ctx, d);
        executeCreate(ctx, d);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta d) {
	    ProcessedTemplate<D> which = (ProcessedTemplate<D>) d.getPrevious();
	    _destroy(ctx);
    }

	private void _destroy(DeploymentPlanningContext ctx) {
		ArtifactDeleteStep step = new ArtifactDeleteStep(getDestroyOrder(), getContainer(), getTargetDirectory());
		step.setTargetDirectoryShared(isTargetDirectoryShared());
		step.setTargetFile(resolveTargetFileName());
		step.setDescription(getDescription(getDestroyVerb()));
		ctx.addStep(step);
	}

	public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}
