/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.overthere.OverthereFile;

public class ArtifactDeleteStep
extends GenericBaseStep {
    private DeployableArtifact artifact;
    private String targetDirectory;
    private boolean targetDirectoryShared;
    private String targetFile;
    private String description;

    public ArtifactDeleteStep(int order, Container container, DeployableArtifact artifact, String targetDirectory) {
        super(order, container);
        this.artifact = artifact;
        this.targetDirectory = (String)Preconditions.checkNotNull((Object)targetDirectory);
    }

    public ArtifactDeleteStep(int order, Container container, String targetDirectory) {
        this(order, container, null, targetDirectory);
    }

    @Override
    protected Step.Result doExecute() throws Exception {
        if (this.artifact != null) {
            return this.deleteArtifact();
        }
        OverthereFile remoteFile = this.getRemoteConnection().getFile(this.targetDirectory);
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            remoteFile = remoteFile.getFile(this.targetFile);
        }
        this.deleteFile(remoteFile);
        return Step.Result.Success;
    }

    protected Step.Result deleteArtifact() {
        OverthereFile localFile = this.artifact.getFile();
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetDirectory);
        if (localFile.isDirectory()) {
            if (this.targetDirectoryShared) {
                for (OverthereFile file : localFile.listFiles()) {
                    this.deleteFile(remoteDir.getFile(file.getName()));
                }
            } else {
                this.deleteFile(remoteDir);
            }
        } else {
            String name = Strings.nullToEmpty((String)this.targetFile).trim().isEmpty() ? this.artifact.getName() : this.targetFile;
            this.deleteFile(remoteDir.getFile(name));
        }
        return Step.Result.Success;
    }

    protected void deleteFile(OverthereFile file) {
        this.getCtx().logOutput("Deleting " + file.getPath() + " on host " + this.getContainer().getHost());
        if (file.exists()) {
            file.deleteRecursively();
        } else {
            this.getCtx().logOutput("File " + file.getPath() + " was already gone from " + this.getContainer().getHost());
        }
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.generateDescription();
        }
        return this.description;
    }

    protected String generateDescription() {
        if (this.artifact != null) {
            return "Deleting " + this.artifact.getName() + " from " + this.getContainer().getHost();
        }
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            return "Deleting file " + this.targetFile + " from directory " + this.targetDirectory + " on host " + this.getContainer().getHost();
        }
        return "Deleting directory " + this.targetDirectory + " from  " + this.getContainer().getHost();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }
}

