package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("serial")
public abstract class GenericBaseStep implements DeploymentStep {

    private int order;
    private String description;
    private Container container;

    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient DeploymentExecutionContext ctx;
    private transient OverthereFile remoteWorkingDir;

    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected GenericBaseStep(int order, String description, Container container) {
        this.order = order;
        this.description = description;
        this.container = container;
    }

    protected GenericBaseStep(int order, Container container) {
        this(order,null,container);
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            return doExecute();
        } finally {
            disconnect();
        }
    }

    protected abstract Result doExecute() throws Exception;

    protected DeploymentExecutionContext getCtx() {
        return ctx;
    }

    protected Container getContainer() {
        return container;
    }

    protected OverthereFile getRemoteWorkingDirectory() {
        if (remoteWorkingDir == null) {
            OverthereFile tempDir = getRemoteConnection().getTempFile("generic_plugin", ".tmp");
            tempDir.mkdir();
            remoteWorkingDir = tempDir;
        }
        return remoteWorkingDir;
    }


    protected OverthereConnection getLocalConnection() {
        if (localConn == null) {
            localConn = LocalConnection.getLocalConnection();
        }
        return localConn;
    }

    protected OverthereConnection getRemoteConnection() {
        if (remoteConn == null) {
            remoteConn = container.getHost().getConnection();
        }
        return remoteConn;
    }

    protected void disconnect() {
        if (localConn != null)
            localConn.close();

        if (remoteConn != null)
            remoteConn.close();

        remoteWorkingDir = null;
        localConn = null;
        remoteConn = null;
    }
}
