/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ClasspathTemplateLoader;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicReference;

public class ConfigurationHolder {
    private static final AtomicReference<Configuration> holder = new AtomicReference();
    private static final String EXPRESSION_TOKEN = "${";

    public static Configuration getConfiguration() {
        Configuration conf = holder.get();
        if (conf == null && !holder.compareAndSet(null, conf = ConfigurationHolder.init())) {
            conf = holder.get();
        }
        return conf;
    }

    public static String resolveExpression(String expression, Object context) {
        if (expression == null || !expression.contains(EXPRESSION_TOKEN)) {
            return expression;
        }
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = new Template("expression", (Reader)new StringReader(expression), cfg);
            StringWriter sw = new StringWriter();
            template.process(context, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private static Configuration init() {
        Configuration conf = new Configuration();
        conf.setNumberFormat("computer");
        conf.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        conf.setObjectWrapper((ObjectWrapper)new CiAwareObjectWrapper());
        return conf;
    }
}

