package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;

public class ConfigurationHolder {

    private static final AtomicReference<Configuration> holder = new AtomicReference<Configuration>();
    private static final String EXPRESSION_TOKEN = "${";


    public static Configuration getConfiguration() {
        Configuration conf = holder.get();
        if (conf == null) {
            conf = init();
            if (!holder.compareAndSet(null, conf)) {
                // another thread has initialized the reference
                conf = holder.get();
            }
        }
        return conf;
    }

    public static String resolveExpression(String expression, Object context) {
        if (expression == null || !expression.contains(EXPRESSION_TOKEN)) {
            return expression;
        }
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = new Template("expression", new StringReader(expression), cfg);
            StringWriter sw = new StringWriter();
            template.process(context, sw);
            return sw.toString();
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        } catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private static Configuration init() {
        Configuration conf = new Configuration();
        conf.setNumberFormat("computer");
        conf.setTemplateLoader(new ClasspathTemplateLoader());
        conf.setObjectWrapper(new CiAwareObjectWrapper());
        return conf;
    }
}
