package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.base.Preconditions.checkNotNull;

@SuppressWarnings("serial")
public class ArtifactCopyStep extends GenericBaseStep {

    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private String description;


    public ArtifactCopyStep(int order, OverthereFile sourceFile, HostContainer container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Preconditions.checkNotNull(targetPath);

    }

    @Override
    protected Result doExecute() throws Exception {
        Preconditions.checkNotNull(targetFileName);

        OverthereFile localFile = resolveSourceFile();
        Preconditions.checkNotNull(localFile);

        OverthereFile remoteDir = getRemoteConnection().getFile(targetPath);

        if (!remoteDir.exists()) {
             if (createTargetPath) {
                 getCtx().logOutput("Creating path " + targetPath + " on host " + getContainer().getHost());
                 remoteDir.mkdirs();
             } else if (localFile.isFile()) {
                getCtx().logError("Path " + targetPath + " on host " + getContainer().getHost() + " does not exist.");
                return Result.Fail;
             }
        }

        OverthereFile remoteFile;
        if (localFile.isDirectory()) {
            remoteFile = remoteDir;
        } else {
            remoteFile = remoteDir.getFile(getTargetFileName());
            if (remoteFile.exists()) {
                getCtx().logOutput(remoteFile.getPath() +" already exists on host " + getContainer().getHost() + ". Will replace.");
                remoteFile.delete();
            }
        }

        getCtx().logOutput("Copying " + localFile.getPath() + " to " + remoteFile.getPath() +" on host " + getContainer().getHost());
        localFile.copyTo(remoteFile);
        return Result.Success;
    }

    protected OverthereFile resolveSourceFile() {
        checkNotNull(sourceFile);
        return sourceFile;
    }

    @Override
    public String getDescription() {
        if (description == null) {
            return "Copying " + getSourceFileDescription() + " to " + getContainer().getHost();
        }
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceFileDescription() {
        return sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public boolean isCreateTargetPath() {
        return createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }
}
