/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Metadata(virtual=true, description="A container that is nested with another container")
public class NestedContainer
extends BaseContainer
implements GenericContainer {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("container", this);
    @Property(required=false, description="Environment variables for container", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();

    public Map<String, String> getEnvVars() {
        return ConfigurationHolder.resolveExpression(this.envVars, this.freeMarkerContext);
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public List<Step> controlTaskDispatch(String name) {
        String scriptPropertyName = name + "Script";
        PropertyDescriptor propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(scriptPropertyName);
        Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{scriptPropertyName, this.getType()});
        String scriptName = ConfigurationHolder.resolveExpression((String)propertyDescriptor.get((ConfigurationItem)this), this.freeMarkerContext);
        return Collections.singletonList(new ScriptExecutionStep(1, scriptName, this, this.freeMarkerContext, "Executing " + name));
    }

    public Container getRootContainer() {
        Object parentContainer = this.getParentContainer();
        if (parentContainer instanceof Container) {
            return (Container)parentContainer;
        }
        if (parentContainer instanceof NestedContainer) {
            return ((NestedContainer)parentContainer).getRootContainer();
        }
        throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
    }

    @Override
    public <T extends GenericContainer> T getParentContainer() {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!pd.isAsContainment()) continue;
            return (T)((GenericContainer)pd.get((ConfigurationItem)this));
        }
        throw new IllegalStateException("This nested container " + this.getType() + " does not have an asContainment relationship to another generic container.");
    }

    public Host getHost() {
        return this.getParentContainer().getHost();
    }
}

