/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.PatternFilenameFilter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.ci.Folder;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true, description="Scripts in the folder are executed against a Container based on a naming convention")
@Placeholders
public class ExecutedFolder<D extends Folder>
extends AbstractDeployed<D>
implements DerivedArtifact<D> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    @Property(required=false, category="Placeholders", description="A key/value pair mapping of placeholders in the deployed artifact to their values. Special values are <ignore> and <empty>")
    private Map<String, String> placeholders = Maps.newHashMap();
    private OverthereFile placeholderProcessedFile;
    @Property(description="Name of the executor script that will be executed for each script found in the folder.")
    private String executorScript;
    @Property(description="Regular expression used to identify a script in the folder.  A successful match should returns a single group to which the rollbackScriptPostfix can be appended to inorder to find the associated rollback script or the script's dependent subfolder.  e.g.([0-9]*-.*)\\.sql")
    private String scriptRecognitionRegex;
    @Property(description="Regular expression used to identify a rollback script in the folder. A successful match should returns a single group, ie the logical script name. e.g. [0-9]*-.*-rollback\\.sql")
    private String rollbackScriptRecognitionRegex;
    @Property(description="A script's associated rollback script is derived by using the 1st group identified by the scriptRecognitionRegex and then appending this postfix to it. e.g give name '01-myscript.sql', regex '([0-9]*-.*)\\.sql' and rollback script postfix '-rollback.sql', we can derive the name of the associated rollback script  to be '01-myscript-rollback.sql'")
    private String rollbackScriptPostfix;
    @Property(hidden=true, defaultValue="common", description="Common folder that should be uploaded to the working directory.")
    private String commonScriptFolderName;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the script.")
    private Set<String> classpathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> templateClasspathResources = Sets.newHashSet();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    public String resolveExpression(String string) {
        return ConfigurationHolder.resolveExpression(string, this.freeMarkerContext);
    }

    public String getDescription(String string, String string2) {
        return String.format("%s %s on %s", string2, string, ((HostContainer)this.getContainer()).getName());
    }

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        this.addSteps(deploymentPlanningContext, this, this.identifyAndOrderCreateScriptsInFolder(this.getDerivedArtifactAsFile()), this.getScriptRecognitionRegex());
    }

    protected void addSteps(DeploymentPlanningContext deploymentPlanningContext, ExecutedFolder<D> executedFolder, List<File> list, String string) {
        File file = executedFolder.getDerivedArtifactAsFile();
        Pattern pattern = Pattern.compile(string);
        File file2 = new File(file, executedFolder.getCommonScriptFolderName());
        for (File file3 : list) {
            File file4;
            ScriptExecutionStep scriptExecutionStep = this.newScriptExecutionStep(file3.getName(), executedFolder);
            if (file2.exists()) {
                scriptExecutionStep.getFileResources().add(file2);
            }
            if ((file4 = new File(file, this.extractScriptPrefix(pattern, file3.getName()))).exists()) {
                scriptExecutionStep.getFileResources().add(file4);
            }
            scriptExecutionStep.setTemplateClasspathResources(Lists.newArrayList(this.getTemplateClasspathResources()));
            scriptExecutionStep.setClasspathResources(Lists.newArrayList(this.getClasspathResources()));
            scriptExecutionStep.setArtifact(file3);
            deploymentPlanningContext.addStep((DeploymentStep)scriptExecutionStep);
        }
    }

    protected ScriptExecutionStep newScriptExecutionStep(String string, ExecutedFolder<D> executedFolder) {
        return new ScriptExecutionStep(executedFolder.getCreateOrder(), executedFolder.getExecutorScript(), (HostContainer)executedFolder.getContainer(), executedFolder.freeMarkerContext, executedFolder.getDescription(string, executedFolder.getCreateVerb()));
    }

    protected String extractScriptPrefix(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.matches();
        Preconditions.checkArgument((bl && matcher.groupCount() == 1 ? 1 : 0) != 0, (String)"Script recognition regular expression '%s' run on script name '%s' must return a single group to which the rollbackScriptPostfix can be appended to, to determine the associated rollback script or to find its dependent sub-directory", (Object[])new Object[]{pattern.pattern(), string});
        return matcher.group(1);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ExecutedFolder executedFolder = (ExecutedFolder)delta.getPrevious();
        File file = executedFolder.getDerivedArtifactAsFile();
        File file2 = this.getDerivedArtifactAsFile();
        this.addSteps(deploymentPlanningContext, executedFolder, this.compareAndIdentifyOrderedRollbackScriptsToRunForDowngrade(file, file2), this.getRollbackScriptRecognitionRegex());
        this.addSteps(deploymentPlanningContext, this, this.compareAndIdentifyOrderedScriptsToRunForUpgrade(file, file2), this.getScriptRecognitionRegex());
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        File file = this.getDerivedArtifactAsFile();
        this.addSteps(deploymentPlanningContext, this, this.identifyAndOrderRollbackScriptsInFolder(file), this.getRollbackScriptRecognitionRegex());
    }

    protected File getDerivedArtifactAsFile() {
        Preconditions.checkNotNull((Object)this.getFile(), (String)"%s has a null file property", (Object[])new Object[]{this});
        Preconditions.checkArgument((boolean)(this.getFile() instanceof LocalFile), (String)"%s has a file that is not a LocalFile but a %s", (Object[])new Object[]{this, this.getFile().getClass().getName()});
        LocalFile localFile = (LocalFile)this.getFile();
        return localFile.getFile();
    }

    protected List<File> identifyAndOrderCreateScriptsInFolder(File file) {
        List<File> list = this.findScriptsToRun(file, this.getScriptRecognitionRegex());
        return Ordering.from((Comparator)new FilenameComparator()).sortedCopy(list);
    }

    protected List<File> findScriptsToRun(File file, String string) {
        Object[] objectArray = file.listFiles((FilenameFilter)new PatternFilenameFilter(string));
        objectArray = objectArray == null ? new File[]{} : objectArray;
        return Lists.newArrayList((Object[])objectArray);
    }

    protected List<File> identifyAndOrderRollbackScriptsInFolder(File file) {
        List<File> list = this.findScriptsToRun(file, this.getRollbackScriptRecognitionRegex());
        return Ordering.from((Comparator)new FilenameComparator()).reverse().sortedCopy(list);
    }

    protected List<File> compareAndIdentifyOrderedScriptsToRunForUpgrade(File file, File file2) {
        List<File> list = this.identifyAndOrderCreateScriptsInFolder(file);
        List<File> list2 = this.identifyAndOrderCreateScriptsInFolder(file2);
        return Ordering.from((Comparator)new FilenameComparator()).sortedCopy(this.difference(list, list2));
    }

    protected List<File> compareAndIdentifyOrderedRollbackScriptsToRunForDowngrade(File file, File file2) {
        List<File> list = this.identifyAndOrderCreateScriptsInFolder(file);
        List<File> list2 = this.identifyAndOrderCreateScriptsInFolder(file2);
        Collection<File> collection = this.difference(list2, list);
        ArrayList arrayList = Lists.newArrayList();
        Pattern pattern = Pattern.compile(this.getScriptRecognitionRegex());
        for (File file3 : collection) {
            String string = this.extractScriptPrefix(pattern, file3.getName()) + this.getRollbackScriptPostfix();
            File file4 = new File(file, string);
            if (!file4.exists()) continue;
            arrayList.add(file4);
        }
        return Ordering.from((Comparator)new FilenameComparator()).reverse().sortedCopy((Iterable)arrayList);
    }

    protected Collection<File> difference(List<File> list, List<File> list2) {
        Set<FileNameEqualityWrapper> set = this.transform(list);
        Set<FileNameEqualityWrapper> set2 = this.transform(list2);
        return Collections2.transform((Collection)Sets.difference(set2, set), (Function)new Function<FileNameEqualityWrapper, File>(){

            public File apply(FileNameEqualityWrapper fileNameEqualityWrapper) {
                return fileNameEqualityWrapper.getFile();
            }
        });
    }

    protected Set<FileNameEqualityWrapper> transform(List<File> list) {
        return Sets.newHashSet((Iterable)Lists.transform(list, (Function)new Function<File, FileNameEqualityWrapper>(){

            public FileNameEqualityWrapper apply(File file) {
                return new FileNameEqualityWrapper(file);
            }
        }));
    }

    public String getScriptRecognitionRegex() {
        return this.scriptRecognitionRegex;
    }

    public void setScriptRecognitionRegex(String string) {
        this.scriptRecognitionRegex = string;
    }

    public String getRollbackScriptRecognitionRegex() {
        return this.rollbackScriptRecognitionRegex;
    }

    public void setRollbackScriptRecognitionRegex(String string) {
        this.rollbackScriptRecognitionRegex = string;
    }

    public String getCommonScriptFolderName() {
        return this.resolveExpression(this.commonScriptFolderName);
    }

    public void setCommonScriptFolderName(String string) {
        this.commonScriptFolderName = string;
    }

    public String getExecutorScript() {
        return this.resolveExpression(this.executorScript);
    }

    public void setExecutorScript(String string) {
        this.executorScript = string;
    }

    public String getRollbackScriptPostfix() {
        return this.resolveExpression(this.rollbackScriptPostfix);
    }

    public void setRollbackScriptPostfix(String string) {
        this.rollbackScriptPostfix = string;
    }

    public Set<String> getClasspathResources() {
        return this.resolveExpression(this.classpathResources);
    }

    public void setClasspathResources(Set<String> set) {
        this.classpathResources = set;
    }

    public Set<String> getTemplateClasspathResources() {
        return this.resolveExpression(this.templateClasspathResources);
    }

    public void setTemplateClasspathResources(Set<String> set) {
        this.templateClasspathResources = set;
    }

    public D getSourceArtifact() {
        return (D)((Object)((Folder)this.getDeployable()));
    }

    public void initFile(PlaceholderReplacer placeholderReplacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)placeholderReplacer);
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> map) {
        this.placeholders = map;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile overthereFile) {
        this.placeholderProcessedFile = overthereFile;
    }

    public static class FileNameEqualityWrapper {
        private final File file;

        public FileNameEqualityWrapper(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FileNameEqualityWrapper fileNameEqualityWrapper = (FileNameEqualityWrapper)object;
            return !(this.file != null ? !this.file.getName().equals(fileNameEqualityWrapper.file.getName()) : fileNameEqualityWrapper.file != null);
        }

        public int hashCode() {
            return this.file != null ? this.file.getName().hashCode() : 0;
        }
    }

    public static class FilenameComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }
    }
}

