/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import org.slf4j.MDC;

public class TemplateArtifactCopyStep
extends ArtifactCopyStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    private Map<String, Object> vars;
    private String templatePath;

    public TemplateArtifactCopyStep(int n, HostContainer hostContainer, Map<String, Object> map, String string, String string2) {
        super(n, null, hostContainer, string2);
        this.vars = Maps.newHashMap(map);
        this.vars.put("step", this);
        this.templatePath = string;
        Preconditions.checkNotNull((Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            Step.Result result = super.doExecute();
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile overthereFile = this.getLocalConnection().getTempFile("generic_plugin", ".tmp");
        this.evaluateTemplate(overthereFile, this.templatePath, this.vars);
        return overthereFile;
    }
}

