package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@SuppressWarnings("serial")
public abstract class BaseDeploymentStep extends BaseStep {

    private int order;

    protected BaseDeploymentStep(int order, String description, HostContainer container) {
        super(description, container);
        this.order = order;
    }

    protected BaseDeploymentStep(int order, HostContainer container) {
        this(order, null, container);
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }
}
