/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.util.HashMap;
import java.util.Set;

@Metadata(virtual=true, description="A script executed on a generic container")
public class ExecutedScript<D extends Deployable>
extends AbstractDeployed<D> {
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the noop operation.")
    private String noopScript;
    @Property(required=false, hidden=true, description="Name of working directory on target host. Default is to create a temporary directory which is deleted when connection is closed.")
    private String remoteWorkingDirectoryPath;
    @Property(required=false, hidden=true, defaultValue="false", description="Retain the specified working directory on target host after completion.")
    private boolean retainRemoteWorkingDirectory = false;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the script.")
    private Set<String> classpathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> templateClasspathResources = Sets.newHashSet();

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb, CheckpointInfo checkpoint, Set<String> stepOptions) {
        return this.addStep(ctx, order, script, verb, checkpoint, stepOptions, null);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb, CheckpointInfo checkpoint, Set<String> stepOptions, Deployed<?, ?> previousDeployed) {
        if (!Strings.nullToEmpty((String)script).trim().isEmpty()) {
            HashMap freeMarkerContext = this.getDeployedAsFreeMarkerContext();
            if (previousDeployed != null) {
                freeMarkerContext = Maps.newHashMap(freeMarkerContext);
                freeMarkerContext.put("previousDeployed", previousDeployed);
            }
            ScriptExecutionStep step = new ScriptExecutionStep(order, script, (HostContainer)this.getContainer(), freeMarkerContext, this.getDescription(verb));
            LocalFile file = (LocalFile)this.getArtifactIfPresent();
            if (file != null && stepOptions.contains("uploadArtifactData")) {
                if (this instanceof DerivedArtifact) {
                    step.setDerivedArtifact((DerivedArtifact)this);
                } else {
                    step.setArtifact(file.getFile());
                }
            }
            if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirectoryPath())) {
                step.setRemoteWorkingDirPath(this.getRemoteWorkingDirectoryPath());
                step.setRetainRemoteWorkingDirOnCompletion(this.isRetainRemoteWorkingDirectory());
            }
            if (stepOptions.contains("uploadTemplateClasspathResources")) {
                step.setTemplateClasspathResources(Lists.newArrayList(this.getTemplateClasspathResources()));
            }
            if (stepOptions.contains("uploadClasspathResources")) {
                step.setClasspathResources(Lists.newArrayList(this.getClasspathResources()));
            }
            if (checkpoint == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, checkpoint.delta, checkpoint.operation);
            }
            return true;
        }
        return false;
    }

    protected OverthereFile getArtifactIfPresent() {
        if (this.getDeployable() instanceof DeployableArtifact) {
            return ((DeployableArtifact)this.getDeployable()).getFile();
        }
        return null;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, this.getCreateOrder(), this.getCreateScript(), this.getCreateVerb(), ExecutedScript.checkpoint(delta, Operation.CREATE), this.getCreateOptions());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        boolean modifyStepAdded = this.addStep(ctx, this.getModifyOrder(), this.getModifyScript(), this.getModifyVerb(), ExecutedScript.checkpoint(delta, Operation.MODIFY), this.getModifyOptions(), delta.getPrevious());
        if (!modifyStepAdded) {
            this.executeDestroy(ctx, delta);
            this.executeCreate(ctx, delta);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        ExecutedScript which = (ExecutedScript)delta.getPrevious();
        which.addStep(ctx, which.getDestroyOrder(), which.getDestroyScript(), which.getDestroyVerb(), ExecutedScript.checkpoint(delta, Operation.DESTROY), this.getDestroyOptions());
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, this.getNoopOrder(), this.getNoopScript(), this.getNoopVerb(), null, this.getNoopOptions());
    }

    public String getCreateScript() {
        return this.resolveExpression(this.createScript);
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return this.resolveExpression(this.modifyScript);
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return this.resolveExpression(this.destroyScript);
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }

    public String getNoopScript() {
        return this.resolveExpression(this.noopScript);
    }

    public void setNoopScript(String noopScript) {
        this.noopScript = noopScript;
    }

    public String getRemoteWorkingDirectoryPath() {
        return this.resolveExpression(this.remoteWorkingDirectoryPath);
    }

    public void setRemoteWorkingDirectoryPath(String remoteWorkingDirectoryPath) {
        this.remoteWorkingDirectoryPath = remoteWorkingDirectoryPath;
    }

    public boolean isRetainRemoteWorkingDirectory() {
        return this.retainRemoteWorkingDirectory;
    }

    public void setRetainRemoteWorkingDirectory(boolean retainRemoteWorkingDirectory) {
        this.retainRemoteWorkingDirectory = retainRemoteWorkingDirectory;
    }

    public Set<String> getClasspathResources() {
        return this.resolveExpression(this.classpathResources);
    }

    public void setClasspathResources(Set<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public Set<String> getTemplateClasspathResources() {
        return this.resolveExpression(this.templateClasspathResources);
    }

    public void setTemplateClasspathResources(Set<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    protected static CheckpointInfo checkpoint(Delta delta) {
        return new CheckpointInfo(delta);
    }

    protected static CheckpointInfo checkpoint(Delta delta, Operation operation) {
        return new CheckpointInfo(delta, operation);
    }

    protected static class CheckpointInfo {
        public final Delta delta;
        public final Operation operation;

        CheckpointInfo(Delta delta) {
            this.delta = delta;
            this.operation = delta.getOperation();
        }

        CheckpointInfo(Delta delta, Operation operation) {
            this.delta = delta;
            this.operation = operation;
        }
    }
}

