package com.xebialabs.deployit.plugin.generic.freemarker;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiAwareObjectWrapper extends DefaultObjectWrapper {

    private final com.xebialabs.deployit.plugin.freemarker.CiAwareObjectWrapper wrapper;

    private ArtifactUploader uploader;

    public CiAwareObjectWrapper() {
        this(null, false);
    }

    /**
     * @deprecated Use {@link #CiAwareObjectWrapper(ArtifactUploader, boolean)} instead.
     */
    public CiAwareObjectWrapper(ArtifactUploader uploader) {
        this(uploader, false);
    }

    public CiAwareObjectWrapper(ArtifactUploader uploader, boolean maskPasswords) {
        wrapper = new com.xebialabs.deployit.plugin.freemarker.CiAwareObjectWrapper(maskPasswords);
        this.uploader = uploader;
    }

    @Override
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        return wrapper.wrap(obj);
    }

    ArtifactUploader getUploader() {
        return uploader;
    }

    com.xebialabs.deployit.plugin.freemarker.CiAwareObjectWrapper getWrapper() {
        return wrapper;
    }
}
