package com.xebialabs.deployit.plugin.generic.processor;


import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;

public class DeployedInjector {

    @PrePlanProcessor
    public static List<Step> inject(DeltaSpecification deltaSpec) {
        for (Delta delta : deltaSpec.getDeltas()) {
            injectDeployed(delta.getPrevious(), deltaSpec.getOperation(), deltaSpec.getPreviousDeployedApplication());
            injectDeployed(delta.getDeployed(), deltaSpec.getOperation(), deltaSpec.getDeployedApplication());
        }
        return Collections.emptyList();
    }

    protected static void injectDeployed(Deployed<?, ?> deployed, Operation operation, DeployedApplication deployedApplication) {
        if (deployed instanceof AbstractDeployed) {
            AbstractDeployed<?> abstractDeployed = (AbstractDeployed<?>) deployed;
            abstractDeployed.setPlanOperation(operation);
            abstractDeployed.setDeployedApplication(deployedApplication);
        }
    }

}
