/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.PreviewExecutionContext;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.MDC;

@StepMetadata(name="manual")
public class InstructionStep
implements Step,
PreviewStep,
SatelliteAware {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    @StepParameter(description="The execution order of the step")
    private Integer order;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans")
    private String description;
    @StepParameter(name="freemarkerContext", description="Dictionary that contains all values available in the template", required=false, calculated=true)
    private Map<String, Object> vars = new HashMap<String, Object>();
    @StepParameter(name="messageTemplate", description="The path to the message template to display to the user and/or send out", required=false)
    private String templatePath;
    @StepParameter(name="mailTo", description="The list of email receivers to send instructions to", required=false)
    private List<String> toAddresses = Lists.newArrayList();
    @StepParameter(description="The email subject line", required=false, calculated=true)
    private String subject;
    @StepParameter(name="mailFrom", description="The email's sender ('From:') email address", required=false, calculated=true)
    private String fromAddress;
    @StepParameter(description="Mail server that is used to send emails", required=false, calculated=true)
    private SmtpServer mailServer;
    private boolean paused = false;
    private Preview preview;
    private HostContainer container;

    public InstructionStep() {
    }

    public InstructionStep(int order, String description, HostContainer container, Map<String, Object> vars, String templatePath) {
        this.order = order;
        this.description = description;
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        this.templatePath = templatePath;
        this.toAddresses = Lists.newArrayList();
        this.container = container;
        Preconditions.checkNotNull((Object)templatePath);
    }

    @RulePostConstruct
    protected void doPostConstruct(StepPostConstructContext ctx) {
        if (!this.toAddresses.isEmpty() && this.mailServer == null) {
            this.mailServer = SmtpServer.getMailServer(ctx.getDeployedApplication().getEnvironment(), ctx.getRepository());
        }
        if (this.mailServer != null && Strings.isNullOrEmpty((String)this.fromAddress)) {
            this.fromAddress = this.mailServer.getFromAddress();
        }
        this.checkMailProperties();
        this.vars = ContextHelper.defaultContext((StepPostConstructContext)ctx, this.vars);
        if (this.subject == null) {
            this.subject = this.description;
        }
    }

    protected void checkMailProperties() {
        if (!(this.mailServer == null && Strings.isNullOrEmpty((String)this.fromAddress) && this.toAddresses.isEmpty() || this.mailServer != null && !Strings.isNullOrEmpty((String)this.fromAddress) && !this.toAddresses.isEmpty())) {
            throw new IllegalArgumentException(String.format("To send e-mail the parameters [message-server, mail-from, mail-to] must be set.", new Object[0]));
        }
    }

    public int getOrder() {
        return this.order;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            HashMap variables = Maps.newHashMap(this.vars);
            variables.put("context", ctx);
            String instructions = this.renderEmailTemplate(this.templatePath, variables);
            if (!this.paused) {
                this.sendInstructions(ctx, instructions);
                StepExitCode stepExitCode = this.pauseExecution();
                return stepExitCode;
            }
            StepExitCode stepExitCode = this.continueExecution(ctx, instructions);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    private void sendInstructions(ExecutionContext ctx, String instructions) {
        this.mailInstructions(instructions, ctx);
        ctx.logOutput(instructions);
    }

    private StepExitCode pauseExecution() {
        this.paused = true;
        return StepExitCode.PAUSE;
    }

    private StepExitCode continueExecution(ExecutionContext ctx, String instructions) {
        ctx.logOutput("Assuming manual process performed. Continuing...");
        if (!Strings.isNullOrEmpty((String)instructions)) {
            ctx.logOutput("------------");
            ctx.logOutput("Instructions");
            ctx.logOutput("------------");
            ctx.logOutput(instructions);
        }
        return StepExitCode.SUCCESS;
    }

    protected void mailInstructions(String instructions, ExecutionContext ctx) {
        if (!this.toAddresses.isEmpty() && this.mailServer != null) {
            ctx.logOutput("Mailing instructions to " + Joiner.on((char)',').join(this.toAddresses));
            this.subject = Strings.isNullOrEmpty((String)this.subject) ? this.getDescription() : this.subject;
            try {
                this.mailServer.sendMessage(this.subject, instructions, this.toAddresses, this.fromAddress);
            }
            catch (MessagingException e) {
                ctx.logError("Failed to send mail.", (Throwable)e);
                ctx.logOutput(Strings.repeat((String)"-", (int)50));
            }
        } else {
            ctx.logOutput("Not sending email instructions.");
        }
    }

    protected String renderEmailTemplate(String template, Map<String, Object> vars) throws IOException, TemplateException {
        if (Strings.isNullOrEmpty((String)template)) {
            return "";
        }
        Configuration cfg = ConfigurationHolder.getConfiguration();
        Template loadedTemplate = cfg.getTemplate(template);
        StringWriter sw = new StringWriter();
        loadedTemplate.setObjectWrapper((ObjectWrapper)new CiAwareObjectWrapper(null, true));
        loadedTemplate.process(vars, (Writer)sw);
        return sw.toString();
    }

    public Preview getPreview() {
        if (this.preview == null) {
            try {
                HashMap variables = Maps.newHashMap(this.vars);
                variables.put("context", new PreviewExecutionContext());
                this.preview = Preview.withSourcePathAndContents((String)this.templatePath, (String)this.renderEmailTemplate(this.templatePath, variables));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.preview;
    }

    public List<String> getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public SmtpServer getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(SmtpServer mailServer) {
        this.mailServer = mailServer;
    }

    public Satellite getSatellite() {
        return this.container.getHost().getSatellite();
    }
}

