package com.xebialabs.deployit.plugin.generic.step;

import java.util.Map;
import org.slf4j.MDC;
import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class TemplateArtifactCopyStep extends ArtifactCopyStep implements PreviewStep {

    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";

    private Map<String, Object> vars;

    private String templatePath;

    private Preview preview;

    public TemplateArtifactCopyStep(int order, HostContainer container, Map<String, Object> vars, String templatePath, String targetPath) {
        super(order, null, container, targetPath);
        this.vars = newHashMap(vars);
        this.vars.put("step",this);
        this.templatePath = templatePath;
        Preconditions.checkNotNull(templatePath);
    }

    @Override
    public Preview getPreview() {
        if(preview == null) {
            try {
                Map<String, Object> variables = newHashMap(vars);
                variables.put("context", new PreviewExecutionContext());
                String contents = evaluateTemplate(templatePath, vars, true);
                preview = Preview.withSourcePathAndContents(templatePath, contents);
            } finally {
                disconnect();
            }
        }
        return preview;
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        MDC.put(MDC_KEY_TEMPLATE_PATH, templatePath);
        try {
            return super.doExecute();
        } finally {
            MDC.remove(MDC_KEY_TEMPLATE_PATH);
        }
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile localTemp = getLocalConnection().getTempFile("generic_plugin", ".tmp");
        evaluateTemplate(localTemp, templatePath, vars);
        return localTemp;
    }

}

