/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.PatternFilenameFilter;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployedSpecific;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.ci.Folder;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.deployed.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true, description="Scripts in the folder are executed against a Container based on a naming convention")
@Placeholders
public class ExecutedFolder<D extends Folder>
extends AbstractDeployed<D>
implements DerivedArtifact<D> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    @Property(required=false, category="Placeholders", description="A key/value pair mapping of placeholders in the deployed artifact to their values. Special values are <ignore> and <empty>")
    @DeployedSpecific
    private Map<String, String> placeholders = Maps.newHashMap();
    private OverthereFile placeholderProcessedFile;
    @Property(description="Name of the executor script that will be executed for each script found in the folder.")
    private String executorScript;
    @Property(description="Regular expression used to identify a script in the folder.  A successful match should returns a single group to which the rollbackScriptPostfix can be appended in order to find the associated rollback script or the script's dependent subfolder.  e.g.([0-9]*-.*)\\.sql")
    private String scriptRecognitionRegex;
    @Property(description="Regular expression used to identify a rollback script in the folder. A successful match should returns a single group, ie the logical script name. e.g. [0-9]*-.*-rollback\\.sql")
    private String rollbackScriptRecognitionRegex;
    @Property(description="A script's associated rollback script is derived by using the 1st group identified by the scriptRecognitionRegex and then appending this postfix to it. e.g give name '01-myscript.sql', regex '([0-9]*-.*)\\.sql' and rollback script postfix '-rollback.sql', we can derive the name of the associated rollback script  to be '01-myscript-rollback.sql'")
    private String rollbackScriptPostfix;
    @Property(hidden=true, defaultValue="true", description="If set to true, modified scripts are also executed on a MODIFY or a NOOP.", required=false)
    private boolean executeModifiedScripts;
    @Property(hidden=true, defaultValue="true", description="If set to true, rollback scripts for modified scripts are also executed on a MODIFY or a NOOP.", required=false)
    private boolean executeRollbackForModifiedScripts;
    @Property(hidden=true, defaultValue="true", description="If set to true, the checkpoint is set after the first script in a folder has been executed. Otherwise the checkpoint is set after the last script in a folder has been executed.", required=false)
    private boolean checkpointAfterFirstScript;
    @Property(hidden=true, defaultValue="common", description="Common folder that should be uploaded to the working directory.")
    private String commonScriptFolderName;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the script.")
    private Set<String> classpathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> templateClasspathResources = Sets.newHashSet();
    private static final Logger logger = LoggerFactory.getLogger(ExecutedFolder.class);

    @Override
    public String resolveExpression(String expression) {
        return ConfigurationHolder.resolveExpression(expression, this.freeMarkerContext);
    }

    public String getDescription(String script, String verb) {
        return String.format("%s %s on %s", verb, script, ((HostContainer)this.getContainer()).getName());
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        Step checkpointStep = ExecutedFolder.addSteps(ctx, this, this.identifyAndOrderCreateScriptsInFolder(this.getDerivedArtifactAsFile()), this.getScriptRecognitionRegex(), this.getCreateOptions(), this.getCreateOrder(), this.getCreateVerb());
        if (checkpointStep != null) {
            ctx.addCheckpoint(checkpointStep, delta, Operation.CREATE);
        }
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        Step checkpointStep;
        ExecutedFolder previousDeployed = (ExecutedFolder)delta.getPrevious();
        File previousFolder = previousDeployed.getDerivedArtifactAsFile();
        File currentFolder = this.getDerivedArtifactAsFile();
        Step firstCheckpointStep = ExecutedFolder.addSteps(ctx, previousDeployed, previousDeployed.compareAndIdentifyOrderedRollbackScriptsToRunForUpdate(previousFolder, currentFolder), previousDeployed.getRollbackScriptRecognitionRegex(), previousDeployed.getModifyOptions(), previousDeployed.getDestroyOrder(), previousDeployed.getDestroyVerb());
        Step secondCheckpointStep = ExecutedFolder.addSteps(ctx, this, this.compareAndIdentifyOrderedScriptsToRunForUpdate(previousFolder, currentFolder), this.getScriptRecognitionRegex(), this.getModifyOptions(), this.getCreateOrder(), this.getCreateVerb());
        if (this.checkpointAfterFirstScript) {
            checkpointStep = firstCheckpointStep != null ? firstCheckpointStep : secondCheckpointStep;
        } else {
            Step step = checkpointStep = secondCheckpointStep != null ? secondCheckpointStep : firstCheckpointStep;
        }
        if (checkpointStep != null) {
            ctx.addCheckpoint(checkpointStep, delta, Operation.MODIFY);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        Step checkpointStep = ExecutedFolder.addSteps(ctx, this, this.identifyAndOrderRollbackScriptsInFolder(this.getDerivedArtifactAsFile()), this.getRollbackScriptRecognitionRegex(), this.getDestroyOptions(), this.getDestroyOrder(), this.getDestroyVerb());
        if (checkpointStep != null) {
            ctx.addCheckpoint(checkpointStep, delta, Operation.DESTROY);
        }
    }

    protected static Step addSteps(DeploymentPlanningContext ctx, ExecutedFolder<?> deployed, List<File> scriptsToRun, String scriptNameRegex, Set<String> stepOptions, int order, String verb) {
        File folder = deployed.getDerivedArtifactAsFile();
        Pattern pattern = Pattern.compile(scriptNameRegex);
        File commonResources = new File(folder, deployed.getCommonScriptFolderName());
        ScriptExecutionStep checkpointStep = null;
        for (File script : scriptsToRun) {
            File dependentSubFolderResource;
            ScriptExecutionStep step = ExecutedFolder.newScriptExecutionStep(script.getName(), deployed, order, verb);
            if (commonResources.exists()) {
                step.getFileResources().add(commonResources);
            }
            if ((dependentSubFolderResource = new File(folder, deployed.extractScriptPrefix(pattern, script.getName()))).exists()) {
                step.getFileResources().add(dependentSubFolderResource);
            }
            if (stepOptions.contains("uploadTemplateClasspathResources")) {
                step.setTemplateClasspathResources(Lists.newArrayList(deployed.getTemplateClasspathResources()));
            }
            if (stepOptions.contains("uploadClasspathResources")) {
                step.setClasspathResources(Lists.newArrayList(deployed.getClasspathResources()));
            }
            if (stepOptions.contains("uploadArtifactData")) {
                step.setArtifact(script);
            }
            ctx.addStep((Step)step);
            if (deployed.isCheckpointAfterFirstScript() && checkpointStep != null) continue;
            checkpointStep = step;
        }
        return checkpointStep;
    }

    protected Step addSteps(DeploymentPlanningContext ctx, ExecutedFolder<D> deployed, List<File> scriptsToRun, String scriptNameRegex, Set<String> stepOptions) {
        File folder = deployed.getDerivedArtifactAsFile();
        Pattern pattern = Pattern.compile(scriptNameRegex);
        File commonResources = new File(folder, deployed.getCommonScriptFolderName());
        ScriptExecutionStep checkpointStep = null;
        for (File script : scriptsToRun) {
            File dependentSubFolderResource;
            ScriptExecutionStep step = ExecutedFolder.newScriptExecutionStep(script.getName(), deployed, this.getCreateOrder(), this.getCreateVerb());
            if (commonResources.exists()) {
                step.getFileResources().add(commonResources);
            }
            if ((dependentSubFolderResource = new File(folder, this.extractScriptPrefix(pattern, script.getName()))).exists()) {
                step.getFileResources().add(dependentSubFolderResource);
            }
            if (stepOptions.contains("uploadTemplateClasspathResources")) {
                step.setTemplateClasspathResources(Lists.newArrayList(this.getTemplateClasspathResources()));
            }
            if (stepOptions.contains("uploadClasspathResources")) {
                step.setClasspathResources(Lists.newArrayList(this.getClasspathResources()));
            }
            if (stepOptions.contains("uploadArtifactData")) {
                step.setArtifact(script);
            }
            ctx.addStep((Step)step);
            if (this.checkpointAfterFirstScript && checkpointStep != null) continue;
            checkpointStep = step;
        }
        return checkpointStep;
    }

    protected static ScriptExecutionStep newScriptExecutionStep(String script, ExecutedFolder<?> deployed) {
        return new ScriptExecutionStep(deployed.getCreateOrder(), deployed.getExecutorScript(), (HostContainer)deployed.getContainer(), deployed.freeMarkerContext, deployed.getDescription(script, deployed.getCreateVerb()));
    }

    protected static ScriptExecutionStep newScriptExecutionStep(String script, ExecutedFolder<?> deployed, int order, String verb) {
        return new ScriptExecutionStep(order, deployed.getExecutorScript(), (HostContainer)deployed.getContainer(), deployed.freeMarkerContext, deployed.getDescription(script, verb));
    }

    protected String extractScriptPrefix(Pattern pattern, String scriptName) {
        Matcher matcher = pattern.matcher(scriptName);
        boolean matches = matcher.matches();
        Preconditions.checkArgument((matches && matcher.groupCount() == 1 ? 1 : 0) != 0, (String)"Script recognition regular expression '%s' run on script name '%s' must return a single group to which the rollbackScriptPostfix can be appended to, to determine the associated rollback script or to find its dependent sub-directory", (Object[])new Object[]{pattern.pattern(), scriptName});
        return matcher.group(1);
    }

    protected File getDerivedArtifactAsFile() {
        Preconditions.checkNotNull((Object)this.getFile(), (String)"%s has a null file property", (Object[])new Object[]{this});
        File ioFile = ArtifactFileUtils.getJavaIoFile(this.getFile());
        Preconditions.checkNotNull((Object)ioFile, (String)"%s could not resolve artifact", (Object[])new Object[]{this});
        return ioFile;
    }

    protected List<File> identifyAndOrderCreateScriptsInFolder(File folder) {
        List<File> scriptsToRun = this.findScriptsToRun(folder, this.getScriptRecognitionRegex());
        return Ordering.from((Comparator)new FilenameComparator()).sortedCopy(scriptsToRun);
    }

    protected List<File> findScriptsToRun(File folder, String pattern) {
        Object[] scriptsToRun = folder.listFiles((FilenameFilter)new PatternFilenameFilter(pattern));
        scriptsToRun = scriptsToRun == null ? new File[]{} : scriptsToRun;
        return Lists.newArrayList((Object[])scriptsToRun);
    }

    protected List<File> identifyAndOrderRollbackScriptsInFolder(File folder) {
        List<File> scriptsToRun = this.findScriptsToRun(folder, this.getRollbackScriptRecognitionRegex());
        return Ordering.from((Comparator)new FilenameComparator()).reverse().sortedCopy(scriptsToRun);
    }

    protected List<File> compareAndIdentifyOrderedScriptsToRunForUpdate(File previousFolder, File currentFolder) {
        List<File> previousScripts = this.identifyAndOrderCreateScriptsInFolder(previousFolder);
        List<File> currentScripts = this.identifyAndOrderCreateScriptsInFolder(currentFolder);
        return Ordering.from((Comparator)new FilenameComparator()).sortedCopy(this.difference(previousScripts, currentScripts, this.executeModifiedScripts));
    }

    protected List<File> compareAndIdentifyOrderedRollbackScriptsToRunForUpdate(File previousFolder, File currentFolder) {
        List<File> previousScripts = this.identifyAndOrderCreateScriptsInFolder(previousFolder);
        List<File> currentScripts = this.identifyAndOrderCreateScriptsInFolder(currentFolder);
        Collection<File> missingScriptsInCurrentFolder = this.difference(currentScripts, previousScripts, this.executeModifiedScripts && this.executeRollbackForModifiedScripts);
        ArrayList rollbackScripts = Lists.newArrayList();
        Pattern pattern = Pattern.compile(this.getScriptRecognitionRegex());
        for (File missingScript : missingScriptsInCurrentFolder) {
            String rollbackScriptName = this.extractScriptPrefix(pattern, missingScript.getName()) + this.getRollbackScriptPostfix();
            File rollbackScript = new File(previousFolder, rollbackScriptName);
            if (!rollbackScript.exists()) continue;
            rollbackScripts.add(rollbackScript);
        }
        return Ordering.from((Comparator)new FilenameComparator()).reverse().sortedCopy((Iterable)rollbackScripts);
    }

    protected Collection<File> difference(List<File> previousFiles, List<File> currentFiles, boolean compareContents) {
        Set<FileNameAndContentsEqualityWrapper> wrappedPreviousFiles = this.transform(previousFiles, compareContents);
        Set<FileNameAndContentsEqualityWrapper> wrappedCurrentFiles = this.transform(currentFiles, compareContents);
        return Collections2.transform((Collection)Sets.difference(wrappedCurrentFiles, wrappedPreviousFiles), (Function)new Function<FileNameAndContentsEqualityWrapper, File>(){

            public File apply(FileNameAndContentsEqualityWrapper input) {
                return input.getFile();
            }
        });
    }

    protected Set<FileNameAndContentsEqualityWrapper> transform(List<File> files, final boolean compareContents) {
        return Sets.newHashSet((Iterable)Lists.transform(files, (Function)new Function<File, FileNameAndContentsEqualityWrapper>(){

            public FileNameAndContentsEqualityWrapper apply(File input) {
                return new FileNameAndContentsEqualityWrapper(input, compareContents);
            }
        }));
    }

    public String getScriptRecognitionRegex() {
        return this.scriptRecognitionRegex;
    }

    public void setScriptRecognitionRegex(String scriptRecognitionRegex) {
        this.scriptRecognitionRegex = scriptRecognitionRegex;
    }

    public String getRollbackScriptRecognitionRegex() {
        return this.rollbackScriptRecognitionRegex;
    }

    public void setRollbackScriptRecognitionRegex(String rollbackScriptRecognitionRegex) {
        this.rollbackScriptRecognitionRegex = rollbackScriptRecognitionRegex;
    }

    public String getRollbackScriptPostfix() {
        return this.resolveExpression(this.rollbackScriptPostfix);
    }

    public void setRollbackScriptPostfix(String rollbackScriptPostfix) {
        this.rollbackScriptPostfix = rollbackScriptPostfix;
    }

    public boolean isExecuteModifiedScripts() {
        return this.executeModifiedScripts;
    }

    public void setExecuteModifiedScripts(boolean executeModifiedScripts) {
        this.executeModifiedScripts = executeModifiedScripts;
    }

    public boolean isExecuteRollbackForModifiedScripts() {
        return this.executeRollbackForModifiedScripts;
    }

    public void setExecuteRollbackForModifiedScripts(boolean executeRollbackForModifiedScripts) {
        this.executeRollbackForModifiedScripts = executeRollbackForModifiedScripts;
    }

    public boolean isCheckpointAfterFirstScript() {
        return this.checkpointAfterFirstScript;
    }

    public void setCheckpointAfterFirstScript(boolean checkpointAfterFirstScript) {
        this.checkpointAfterFirstScript = checkpointAfterFirstScript;
    }

    public String getCommonScriptFolderName() {
        return this.resolveExpression(this.commonScriptFolderName);
    }

    public void setCommonScriptFolderName(String commonScriptFolderName) {
        this.commonScriptFolderName = commonScriptFolderName;
    }

    public String getExecutorScript() {
        return this.resolveExpression(this.executorScript);
    }

    public void setExecutorScript(String executorScript) {
        this.executorScript = executorScript;
    }

    public Set<String> getClasspathResources() {
        return this.resolveExpression(this.classpathResources);
    }

    public void setClasspathResources(Set<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public Set<String> getTemplateClasspathResources() {
        return this.resolveExpression(this.templateClasspathResources);
    }

    public void setTemplateClasspathResources(Set<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    public D getSourceArtifact() {
        return (D)((Object)((Folder)this.getDeployable()));
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    private static class FileNameAndContentsEqualityWrapper {
        private final File file;
        private final boolean compareContents;

        public FileNameAndContentsEqualityWrapper(File file, boolean compareContents) {
            this.file = file;
            this.compareContents = compareContents;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileNameAndContentsEqualityWrapper that = (FileNameAndContentsEqualityWrapper)o;
            if (!this.file.getName().equals(that.file.getName())) {
                return false;
            }
            if (!this.compareContents) {
                logger.trace("Not comparing contents of two versions of [{}]", (Object)this.file.getName());
                return true;
            }
            if (this.file.length() != that.file.length()) {
                logger.trace("Found two versions of [{}] to have a different length: [{}] vs. [{}]", new Object[]{this.file.getName(), this.file.length(), that.file.length()});
                return false;
            }
            try {
                boolean contentsEqual = Files.equal((File)this.file, (File)that.file);
                logger.trace("Found two versions of [{}] to be [{}]", (Object)this.file.getName(), (Object)(contentsEqual ? "equal" : "not equal"));
                return contentsEqual;
            }
            catch (IOException exc) {
                throw new RuntimeException(String.format("Cannot compare contents of [%s] and [%s]", this.file, that.file), exc);
            }
        }

        public int hashCode() {
            return this.file != null ? this.file.getName().hashCode() : 0;
        }
    }

    private static class FilenameComparator
    implements Comparator<File> {
        private FilenameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

