#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Start website, if it exists and has not already been started.
$websitePath = "IIS:\Sites\$websiteName"
if (!(Test-Path $websitePath)) {
    Write-Host "Website [$websiteName] does not exist."
    Exit 1
} 
elseif((Get-Item $websitePath).State -eq "Started") {
    Write-Host "Website [$websiteName] has already been started."
} 
else {
    Write-Host "Starting website [$websiteName]."
    Start-Website -Name $websiteName | Out-Null
    # Start-Website is aysnchronous, need to verify if website is actually started
    $currentRetry = 1;
    $success = $false;
    do {
        $status = (Get-Item $websitePath).State
        if ($status -eq "Started"){
            Write-Host "Website [$websiteName] has started."
                $success = $true;
        }
        Start-Sleep -s $deployed.sleepBetweenChecks
        $currentRetry = $currentRetry + 1;
    }
    while (!$success -and $currentRetry -le $deployed.numberOfChecks)
    if ($currentRetry -eq $deployed.numberOfChecks -And $success -eq $false) {
        Write-Host "Website [$websiteName] is still not started. Please retry."
        Exit 1
    }
}
