#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Destroy application pool, if it exists.
$appPool = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class IIsApplicationPool -Filter "Name ='W3SVC/APPPOOLS/$applicationPoolName'"
if ($appPool){
    Write-Host "Destroying application pool [$applicationPoolName]."
    Try {
        $appPool.Delete()
    } Catch [System.Management.Automation.MethodInvocationException] {
        # The exception that is normally thrown is very generic / vague
        throw "Failed deleting application pool '$applicationPoolName'. Check that it does not host any website or application."
    }
} else {
    Write-Host "Application pool [$applicationPoolName] has already been destroyed."
}
