#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
#Construct attribute values in format required for Remove-WebConfigurationProperty
Write-Host "Remove ConfigCollectionElement started"

$attrMap = @{}
$attrList = $deployed.attributes.split([Environment]::NewLine)
Foreach ($attr IN $attrList) {
    if ($attr.Contains("~")) {
        $tokens = $attr.split("~")
        $attrMap.add($tokens[0],$tokens[1])
    }
}

#Remove CollectionElement
if($deployed.psPath -ne $null -and $deployed.location -ne $null) {
    Write-Host "Command executed to Remove WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -AtElement $attrMap"
    $collectionElement = Remove-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -AtElement $attrMap
} elseif ($deployed.psPath -ne $null) {
    Write-Host "Command executed to Remove WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -AtElement $attrMap"
    $collectionElement = Remove-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -AtElement $attrMap
} elseif ($deployed.location -ne $null) {
    Write-Host "Command executed to Remove WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -AtElement $attrMap"
    $collectionElement = Remove-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -AtElement $attrMap
} else {
    Write-Host "Command executed to Remove WebConfigurationProperty -Filter $deployed.filter -Name . -AtElement $attrMap"
    $collectionElement = Remove-WebConfigurationProperty -Filter $deployed.filter -Name . -AtElement $attrMap
}

Write-Host "Remove ConfigCollectionElement completed"
