#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Destroy website, if it exists.
$websitePath = "IIS:\Sites\$websiteName"
if (Test-Path $websitePath) {
    Write-Host "Destroying website [$websiteName]."
    Remove-Website -Name $websiteName | Out-Null
} else {
    Write-Host "Website [$websiteName] has already been destroyed."
}

