if (!(Test-Path $deployed.physicalPath)) {
	Write-Output ("Creating empty application physical path " + $deployed.physicalPath)
	New-Item $deployed.physicalPath -type directory -force | Out-Null
}

Write-Output ("Creating application " + $deployed.name)
$newApplication = New-Item ("IIS:\Sites\" + $deployed.websiteName + "\" + $deployed.name) -Type Application -PhysicalPath $deployed.physicalPath
Set-ItemProperty -path $newApplication.PSPath -name enabledProtocols -value $deployed.protocols
if($deployed.applicationPoolName) {
	Set-ItemProperty -path $newApplication.PSPath -name applicationPool -value $deployed.applicationPoolName
}
