Function convertServiceAccountToIdentityType($serviceAccount) {
    $serviceAccount = $serviceAccount.toLower()
    $serviceAccountType = 2   #networkservice
    if ($serviceAccount -eq "localsystem") {
        $serviceAccountType = 0
    } elseif ($serviceAccount -eq "localservice") {
        $serviceAccountType = 1
    }
    return $serviceAccountType
}

# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Verify application pool name is not being changed.
if($previousDeployed) {
    $previousApplicationPoolName = if($previousDeployed.applicationPoolName) { $previousDeployed.applicationPoolName } else { $previousDeployed.name }
    if($applicationPoolName -ne $previousApplicationPoolName) {
        Write-Output "Renaming an application pool is not supported. Undeploy and deploy the application pool instead."
        Exit 1
    }
}

# Verify username and password are provided if serviceAccount if set to 'SpecificUser'.
if ($deployed.serviceAccount -eq "SpecificUser") {
    if (!$deployed.username) {
        throw "Username is required when service account is set to [SpecificUser]."
    }
    if (!$deployed.password) {
        throw "Password is required when service account is set to [SpecificUser]."
    }
}

# Check whether application pool already exists and then either retrieve or create it.
$appPoolSetting = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class IIsApplicationPoolSetting -Filter "Name ='W3SVC/APPPOOLS/$applicationPoolName'"
if ($appPoolSetting) {
    Write-Output "Modifying existing application pool [$applicationPoolName]."
} else {
    Write-Output "Creating new application pool [$applicationPoolName]."

    $appPoolSetting = ([WMICLASS]"ROOT\MicrosoftIISv2:IIsApplicationPoolSetting").CreateInstance()
    $appPoolSetting.Name = "W3SVC/AppPools/$applicationPoolName"
}

# Set application pool properties.
if ($deployed.serviceAccount -eq "SpecificUser") {
    $appPoolSetting.AppPoolIdentityType = 3
    $appPoolSetting.WAMUsername = $deployed.username
    $appPoolSetting.WAMUserPass = $deployed.password
} elseif ($deployed.serviceAccount) {
    $appPoolSetting.AppPoolIdentityType = convertServiceAccountToIdentityType $deployed.serviceAccount
}

# Save application pool.
$appPoolSetting.Put() | Out-Null

# Stop application pool so that we can configure it correctly before starting it again from start-application-pool.ps1
$appPool = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class IIsApplicationPool -Filter "Name ='W3SVC/APPPOOLS/$applicationPoolName'"
$appPool.Stop()
    
