# Get provided application path or use the deployed name.
$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

# Verify website exists.
$website = getWebsite $deployed.websiteName
if (!$website) {
    Write-Output "Website [$($deployed.websiteName)] has already been destroyed."
    return
}

# Destroy application, if it exists.
$application = getVirtualDirectory $website $applicationPath
if ($application) {
    Write-Output "Destroying application [$applicationPath] in website [$($deployed.websiteName)]."
    $application.DeleteTree()
} else {
    Write-Output "Application [$applicationPath] in website [$($deployed.websiteName)] has already been destroyed."
}
