# Get provided application path or use the deployed name.
$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

# Verify application path and website name are not being changed.
if($previousDeployed) {
    $previousApplicationPath = if($previousDeployed.applicationPath) { $previousDeployed.applicationPath } else { $previousDeployed.name }
    if($applicationPath -ne $previousApplicationPath) {
        Write-Host "Renaming an application is not supported. Undeploy and deploy the application instead."
        Exit 1
    }

    if($deployed.websiteName -ne $previousDeployed.websiteName) {
        Write-Host "Moving an application is not supported. Undeploy and deploy the application instead."
        Exit 1
    }
}

# Verify website exists.
$website = getWebsite $deployed.websiteName
if (!$website) {
    throw "Website [$($deployed.websiteName)] does not exist."
}

# Create physical path if it doesn't exist yet.
if (!(Test-Path $deployed.physicalPath)) {
    Write-Host "Creating empty application physical path [$($deployed.physicalPath)]."
    if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Host "Cannot create directory [$($deployed.physicalPath)]."
        Exit 1
    }
}

# Check whether application already exists and then either retrieve or create it.
$application = getVirtualDirectory $website $applicationPath
if ($application) {
    Write-Host "Modifying existing application [$applicationPath] in website [$($deployed.websiteName)]."
} else {
    Write-Host "Creating new application [$applicationPath] in website [$($deployed.websiteName)]."
    $application = ([ADSI]"IIS://localhost/$($website.Name)/ROOT").Create("IIsWebVirtualDir", $applicationPath)

    # Create the application on the virtual directory
    $application.AppCreate3(2, $deployed.applicationPoolName, $FALSE)
}

# Set application properties.
$application.Put("Path", $deployed.physicalPath)
$application.Put("DefaultDoc", "Default.aspx,Default.htm,Default.asp,index.htm")
$application.Put("AppFriendlyName", $applicationPath)
$application.put("AppPoolId", $deployed.applicationPoolName)

# Save application.
$application.SetInfo()

# Set .NET version
if($deployed.dotNetVersion) {
    $websiteVirtualDirectory = "$($website.Name)/Root/$applicationPath"
    updateDotNetVersionForVirtualDirectory $websiteVirtualDirectory $deployed.container.dotNetFrameworkInstallationPath $deployed.dotNetVersion
}
