Function inspectVirtualDirectory($website, $vd) {
    $vdName = $vd.Name.substring($vd.Name.lastIndexOf("/"))
    $id = $container.id + $vdName
    discovered $id $prototype.type
    inspectedProperty $id "physicalPath" $vd.Path
    inspectedProperty $id "websiteName" $website
    inspectedItem $id
}

$websites = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class "IIsWebServerSetting"
if($websites) {
    foreach ($ws in $websites) {
        $virtualDirs = Get-WmiObject IIsWebVirtualDirSetting -Namespace "ROOT\MicrosoftIISv2" | Where-Object { $_.Name -like "$($ws.name)/*" }
        if ($virtualDirs) {
            foreach ($vds in $virtualDirs) {
                $vd = Get-WmiObject IIsWebVirtualDir -Namespace "ROOT\MicrosoftIISv2" | Where-Object { $_.Name -eq $vds.Name }
                if ($vd.AppGetStatus().ReturnValue -eq 2) {
                   inspectVirtualDirectory $ws.serverComment $vds
                }
            }
        }
    }
}
