$appPools = Get-ChildItem IIS:\AppPools
if($appPools) {
    foreach ($ap in $appPools) {
        $id = $container.id + "/" + $ap.name
        discovered $id $prototype.type
        inspectedProperty $id "managedRuntimeVersion" $ap.managedRuntimeVersion
        inspectedProperty $id "enable32BitAppOnWin64" ([string]$ap.enable32BitAppOnWin64).ToLower()
        if ($ap.managedPipelineMode -eq "Classic") {
            inspectedProperty $id "useClassicManagedPipeline" "true"
        }

        $processModel = $ap.processModel
        inspectedProperty $id "serviceAccount" $processModel.identityType
        if ($processModel.identityType -eq "SpecificUser") {
            inspectedProperty $id "username" $processModel.username
            inspectedProperty $id "password" $processModel.password
        }

        inspectedItem $id
    }
}
