#

$websites = Get-Website
if($websites) {
    foreach ($website in $websites) {
        $id = "$($container.id)/$($website.name)"
        discovered $id $prototype.type
    
        inspectedProperty $id "physicalPath" $website.physicalPath
        inspectedProperty $id "applicationPoolName" $website.applicationPool

        inspectDirectoryBrowsing $id "IIS:\Sites\$($website.name)"

        inspectedItem $id

        inspectAuthentication $id "IIS:\Sites\$($website.name)"
    
        foreach ($binding in (Get-WebBinding -Name $website.name)) {
            $bid = "$id/$($binding.protocol)_$($binding.bindingInformation -replace "[:*]", "_")"
            discovered $bid "iis.WebsiteBinding"
    
            $parts = $binding.bindingInformation.split(":")
            Assert {$parts.length -eq 3} "Web binding expected to be in format 'ipAddress:port:hostHeader' but was [$($binding.bindingInformation)]"
    
            inspectedProperty $bid "protocol" $binding.protocol
            inspectedProperty $bid "ipAddress" $parts[0]
            inspectedProperty $bid "port" $parts[1]
            inspectedProperty $bid "hostHeader" $parts[2]
            
            inspectedItem $bid
        }
        
    }
}
