/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.iis;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeToIisPlugin390
extends JcrUpgrade {
    private static Logger logger = LoggerFactory.getLogger(UpgradeToIisPlugin390.class);

    public Version upgradeVersion() {
        return Version.valueOf((String)"iis-plugin", (String)"3.9.0");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        try {
            this.createWebsiteBindingSpecs(repository);
            this.createWebsiteBindings(repository);
            return true;
        }
        catch (RepositoryException exc) {
            throw new UpgradeException("Cannot upgrade repository to format for " + this.upgradeVersion(), (Exception)((Object)exc));
        }
    }

    private void createWebsiteBindingSpecs(RawRepository repository) throws RepositoryException {
        List websiteSpecs = repository.findNodesByType(Type.valueOf((String)"iis.WebsiteSpec"));
        for (Node websiteSpec : websiteSpecs) {
            this.createWebsiteBindingSpec(repository, websiteSpec);
        }
    }

    private void createWebsiteBindingSpec(RawRepository repository, Node websiteSpec) throws RepositoryException {
        String port = "";
        if (websiteSpec.hasProperty("port")) {
            port = websiteSpec.getProperty("port").getString();
        }
        logger.info("Creating [iis.WebsiteBindingSpec] at [{}/binding1]", (Object)websiteSpec.getPath().substring(1));
        Node websiteBindingSpec = websiteSpec.addNode("binding1");
        websiteBindingSpec.addMixin("deployit:configurationItem");
        websiteBindingSpec.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        websiteBindingSpec.setProperty("$configuration.item.type", "iis.WebsiteBindingSpec");
        websiteBindingSpec.setProperty("$lastModified", Calendar.getInstance());
        websiteBindingSpec.setProperty("port", port);
    }

    private void createWebsiteBindings(RawRepository repository) throws RepositoryException {
        List websites = repository.findNodesByType(Type.valueOf((String)"iis.Website"));
        for (Node website : websites) {
            this.createWebsiteBinding(repository, website);
        }
    }

    private void createWebsiteBinding(RawRepository repository, Node website) throws RepositoryException {
        int port = 80;
        if (website.hasProperty("port")) {
            port = (int)website.getProperty("port").getLong();
        }
        Node websiteBinding = website.addNode("binding1");
        logger.info("Creating [iis.WebsiteBinding] at [{}/binding1]", (Object)website.getPath().substring(1));
        websiteBinding.addMixin("deployit:configurationItem");
        websiteBinding.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        websiteBinding.setProperty("$configuration.item.type", "iis.WebsiteBinding");
        websiteBinding.setProperty("$lastModified", Calendar.getInstance());
        websiteBinding.setProperty("deployable", website.getProperty("deployable").getNode().getNode("binding1"));
        websiteBinding.setProperty("port", (long)port);
    }
}

