/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;

public abstract class TwiddleStep
implements SatelliteAware {
    private transient OverthereConnection remoteConn;
    private transient OverthereFile remoteWorkingDir;
    private final HostContainer container;
    private final String scriptTemplatePath;
    protected transient ExecutionContext ctx;

    public TwiddleStep(HostContainer container, String scriptTemplatePath) {
        this.container = container;
        this.scriptTemplatePath = (String)Preconditions.checkNotNull((Object)scriptTemplatePath, (Object)"scriptTemplatePath is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            String osSpecificTemplate = this.resolveOsSpecificTemplate();
            String executableContent = this.evaluateTemplate(osSpecificTemplate, this.getVars());
            this.logger().debug(executableContent);
            OverthereFile executable = this.uploadExecutable(executableContent, OverthereUtils.getName((String)osSpecificTemplate));
            CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
            TwiddleProcessOutputHandler parser = new TwiddleProcessOutputHandler();
            MultipleOverthereProcessOutputHandler handle = MultipleOverthereProcessOutputHandler.multiHandler((OverthereProcessOutputHandler[])new OverthereProcessOutputHandler[]{new DefaultProcessOutputHandler(ctx), parser});
            ctx.logOutput("Executing " + executable.getPath() + " on host " + this.container.getHost());
            int rc = this.getRemoteConnection().execute((OverthereProcessOutputHandler)handle, cmdLine);
            if (rc == 0) {
                this.doHandle(parser);
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.FAIL;
            return stepExitCode;
        }
        finally {
            this.disconnect();
        }
    }

    protected void disconnect() {
        if (this.remoteConn != null) {
            this.remoteConn.close();
        }
        this.remoteWorkingDir = null;
        this.remoteConn = null;
        this.ctx = null;
    }

    protected Map<String, Object> getVars() {
        return Collections.emptyMap();
    }

    protected void doHandle(TwiddleProcessOutputHandler handler) {
    }

    private String resolveOsSpecificTemplate() {
        Object osSpecificScript = this.scriptTemplatePath;
        if (this.scriptTemplatePath.lastIndexOf(46) == -1) {
            OperatingSystemFamily os = this.container.getHost().getOs();
            osSpecificScript = (String)osSpecificScript + os.getScriptExtension();
        }
        if (!TwiddleStep.classpathResourceExists((String)osSpecificScript)) {
            throw new IllegalArgumentException("Resource " + (String)osSpecificScript + " not found in classpath");
        }
        return osSpecificScript;
    }

    private String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment(vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper((ArtifactUploader)new WorkingFolderUploader(), false)).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            this.logger().error("evaluate Template error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    private OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = this.getRemoteConnection().getTempFile("jboss_plugin", ".tmp");
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    private OverthereFile uploadExecutable(String content, String fileName) {
        OverthereFile targetExecutable = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)targetExecutable);
        targetExecutable.setExecutable(true);
        return targetExecutable;
    }

    private static boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public Satellite getSatellite() {
        return this.container.getHost().getSatellite();
    }

    public HostContainer getContainer() {
        return this.container;
    }

    protected abstract Logger logger();

    private class WorkingFolderUploader
    implements ArtifactUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();

        private WorkingFolderUploader() {
        }

        public String upload(Artifact file) {
            if (this.uploadedFiles.containsKey(file.getName())) {
                return this.uploadedFiles.get(file.getName());
            }
            this.uploadedFiles.put(file.getName(), file.getFile().getPath());
            return file.getFile().getPath();
        }
    }
}

