/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwiddleQueryConnectorContainerInspectionStep<T>
extends TwiddleStep
implements Step {
    private final Map<String, Object> vars = Maps.newHashMap();
    boolean isWindows = this.getContainer().getHost().getOs() == OperatingSystemFamily.WINDOWS;
    private static final Logger logger = LoggerFactory.getLogger(TwiddleQueryConnectorContainerInspectionStep.class);

    public TwiddleQueryConnectorContainerInspectionStep(Container genericContainer, String expr) {
        super((HostContainer)genericContainer, (String)genericContainer.getProperty("queryTemplate"));
        this.vars.put("container", genericContainer);
        this.vars.put("expr", expr);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return String.format("Query JBoss Server %s", this.vars.get("expr"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        final List<String> values = handler.getValues();
        if (this.isWindows) {
            values.remove(0);
        }
        for (String mbean : values) {
            if (this.isWindows) {
                mbean = mbean.replace("%2F", "%%2F");
            }
            TwiddleContainerInspectionStep twiddleContainerInspectionStep = new TwiddleContainerInspectionStep(this.getContainer(), mbean, "protocolHandlerClassName port", null){

                @Override
                protected void doHandle(TwiddleProcessOutputHandler handler) {
                    if (values.size() != 2) {
                        throw new RuntimeException("Expected number of answer 2, not " + values.size());
                    }
                    String protocol = (String)values.get(0);
                    String port = (String)values.get(1);
                    if (protocol.contains("Ajp")) {
                        this.getContainer().setProperty("ajpPort", (Object)Integer.parseInt(port));
                    } else if (protocol.contains("Http")) {
                        this.getContainer().setProperty("httpPort", (Object)Integer.parseInt(port));
                    }
                }
            };
            try {
                twiddleContainerInspectionStep.execute(this.ctx);
            }
            catch (Exception e) {
                throw new RuntimeException("Inspecting " + mbean + " for " + this.getDescription() + "failed", e);
            }
        }
    }

    @Override
    protected Logger logger() {
        return logger;
    }
}

