/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.jbossas.step.PropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwiddleContainerInspectionStep
extends TwiddleStep
implements Step {
    private final Map<String, Object> vars = Maps.newHashMap();
    private final PropertyConverter<?> converter;
    private static final Logger logger = LoggerFactory.getLogger(TwiddleContainerInspectionStep.class);

    public TwiddleContainerInspectionStep(HostContainer deployedJBossResource, String mbean, String attribute, PropertyConverter<?> converter) {
        super(deployedJBossResource, (String)deployedJBossResource.getProperty("inspectTemplate"));
        this.converter = converter;
        this.vars.put("container", this.getContainer());
        this.vars.put("mbean", mbean);
        this.vars.put("attribute", attribute);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return String.format("Inspect JBoss Server %s/%s", this.vars.get("mbean"), this.vars.get("attribute"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        Iterator<String> values = handler.getValues().iterator();
        if (this.getContainer().getHost().getOs() == OperatingSystemFamily.WINDOWS) {
            values.next();
        }
        String inspectedValue = values.next();
        if (values.hasNext()) {
            throw new RuntimeException("Too many answers (expected 1 element but result was " + handler.getValues() + ")");
        }
        Object propertyInspectedValue = this.converter.getConverter().apply((Object)inspectedValue);
        this.getContainer().setProperty(this.converter.getProperty(), propertyInspectedValue);
    }

    @Override
    protected Logger logger() {
        return logger;
    }
}

