/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;
import org.apache.velocity.VelocityContext;

public class CreateJbossasQueueStep
extends JbossasStepBase {
    private JbossasQueue queue;

    public CreateJbossasQueueStep(JbossasServer server, JbossasQueue queue) {
        super(server);
        this.queue = queue;
        this.setDescription("Create queue " + (Object)((Object)queue) + " on JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        String evaluatedTemplate = this.generateQueueConfigurationFile();
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile tmpDir = s.getFile(this.server.getTmpDirPath());
            HostFile tmpQueueServiceFile = s.getFile(tmpDir, this.queue.getFilename());
            ctx.logOutput("Copying queue configuration to " + tmpQueueServiceFile.getPath() + " on " + this.server.getHost());
            HostFileUtils.putStringToHostFile((String)evaluatedTemplate, (HostFile)tmpQueueServiceFile);
            HostFile deployDir = s.getFile(this.server.getDeployDirPath());
            HostFile queueServiceFile = s.getFile(deployDir, this.queue.getFilename());
            ctx.logOutput("Moving queue configuration from " + tmpQueueServiceFile.getPath() + " to " + queueServiceFile.getPath() + " on " + this.server.getHost());
            tmpQueueServiceFile.moveTo(queueServiceFile);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }

    private String generateQueueConfigurationFile() {
        if (this.server.getVersion() == JbossasVersion.JBOSSAS_UNKNOWN) {
            throw new ResolutionException("Unknow JBoss version");
        }
        String templateResourceName = this.server.getVersion() == JbossasVersion.JBOSSAS_40 ? "template-queue-service-jboss4.xml.vm" : "template-queue-service-jboss5.xml.vm";
        VelocityContext context = new VelocityContext();
        context.put("queue", (Object)this.queue);
        return VelocityUtils.evaluateTemplate(context, "com/xebialabs/deployit/plugin/jbossas/step/" + templateResourceName);
    }
}

