package com.xebialabs.deployit.plugin.jbossas.container.v4;

import com.google.common.base.Functions;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.jbossas.container.BaseServer;
import com.xebialabs.deployit.plugin.jbossas.step.SimplePropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleQueryConnectorContainerInspectionStep;

@SuppressWarnings("serial")
@Metadata(description="Jboss 4.x server")
public class Server extends BaseServer{

	@SuppressWarnings("rawtypes")
    @Inspect
	public void inspect(InspectionPlanningContext ctx) {
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "HomeDir", new SimplePropertyConverter<String>("home", Functions.<String>identity())));
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "ServerName", new SimplePropertyConverter<String>("serverName", Functions.<String>identity())));
		ctx.addStep(new TwiddleContainerInspectionStep<Integer>(this, "jboss.system:type=ServerConfig", "SpecificationVersion", new SimplePropertyConverter<Integer>("version", DECODE_VERSION)));
		ctx.addStep(new TwiddleQueryConnectorContainerInspectionStep(this,"jboss.web:type=Connector,*"));
	}
}
