/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.deployed;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleResourceInspectionStep;
import java.util.Collection;
import java.util.TreeSet;

public class Resource<D extends Deployable>
extends ProcessedTemplate<D> {
    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        ctx.addStep(new TwiddleResourceInspectionStep(this, "jndiName"));
    }

    public String toLowerHyphen(String s) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, s);
    }

    public String toUpperCamel(String s) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, s);
    }

    public String getTemplate() {
        return this.resolveExpression(super.getTemplate());
    }

    public String getInspectTemplate() {
        String inspectTemplate = (String)this.getSyntheticProperty("inspectTemplate");
        return this.resolveExpression(inspectTemplate);
    }

    public Collection<String> getParameters() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.type);
        return Sets.newTreeSet((Iterable)Collections2.filter(this.getSyntheticProperties().keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String propertyName) {
                if (descriptor.getPropertyDescriptor(propertyName).isHidden()) {
                    return false;
                }
                return !propertyName.contains("_");
            }
        }));
    }

    public Collection<ParameterProperty> getParametersProperties() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.type);
        TreeSet filtered = Sets.newTreeSet((Iterable)Collections2.filter(this.getSyntheticProperties().keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String propertyName) {
                if (descriptor.getPropertyDescriptor(propertyName).isHidden()) {
                    return false;
                }
                return propertyName.contains("_");
            }
        }));
        return Collections2.transform((Collection)filtered, (Function)new Function<String, ParameterProperty>(){

            public ParameterProperty apply(String propertyName) {
                String[] split = propertyName.split("_");
                if (split.length != 2) {
                    throw new RuntimeException("Cannot decode " + propertyName);
                }
                String node = Resource.this.toLowerHyphen(split[0]);
                String attribute = Resource.this.toLowerHyphen(split[1]).replace('-', '.');
                Object value = Resource.this.getSyntheticProperty(propertyName);
                return new ParameterProperty(node, attribute, value);
            }
        });
    }

    public class ParameterProperty {
        final String node;
        final String attribute;
        final Object value;

        public ParameterProperty(String node, String attribute, Object value) {
            this.node = node;
            this.attribute = attribute;
            this.value = value;
        }

        public String getNode() {
            return this.node;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

