/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.List;
import java.util.Map;

public class TwiddleQueryConnectorContainerInspectionStep<T>
extends TwiddleStep
implements InspectionStep {
    private final Map<String, Object> vars = Maps.newHashMap();

    public TwiddleQueryConnectorContainerInspectionStep(Container genericContainer, String expr) {
        super((HostContainer)genericContainer, (String)genericContainer.getProperty("queryTemplate"));
        this.vars.put("container", genericContainer);
        this.vars.put("expr", expr);
    }

    public String getDescription() {
        return String.format("Query JBoss Server %s", this.vars.get("expr"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        for (String mbean : handler.getValues()) {
            TwiddleContainerInspectionStep twiddleContainerInspectionStep = new TwiddleContainerInspectionStep(this.getContainer(), mbean, "protocolHandlerClassName port", null){

                @Override
                protected void doHandle(TwiddleProcessOutputHandler handler) {
                    List<String> values = handler.getValues();
                    if (values.size() != 2) {
                        throw new RuntimeException("Expected number of answer 2, not " + values.size());
                    }
                    String protocol = values.get(0);
                    String port = values.get(1);
                    if (protocol.contains("Ajp")) {
                        this.getContainer().setProperty("ajpPort", (Object)Integer.parseInt(port));
                    } else if (protocol.contains("Http")) {
                        this.getContainer().setProperty("httpPort", (Object)Integer.parseInt(port));
                    }
                }
            };
            try {
                twiddleContainerInspectionStep.execute(this.ctx);
            }
            catch (Exception e) {
                throw new RuntimeException("Inspecting " + mbean + " for " + this.getDescription() + "failed", e);
            }
        }
    }
}

