package com.xebialabs.deployit.plugin.jbossas.container;

import com.google.common.base.Functions;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.jbossas.step.SimplePropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleQueryConnectorContainerInspectionStep;

@SuppressWarnings("serial")
@Metadata(description = "Jboss 6 application server")
public class ServerV6 extends BaseServer {

	@Inspect
	public void inspect(InspectionPlanningContext ctx) {
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "JBossHome", new SimplePropertyConverter<String>("home",
				DECODE_FILE_VALUE)));
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "ServerName", new SimplePropertyConverter<String>(
		        "serverName", Functions.<String> identity())));
		ctx.addStep(new TwiddleContainerInspectionStep<Integer>(this, "jboss.system:type=Server", "VersionNumber", new SimplePropertyConverter<Integer>(
		        "version", DECODE_VERSION)));
		ctx.addStep(new TwiddleQueryConnectorContainerInspectionStep<Object>(this, "jboss.web:type=Connector,*"));
	}

}
