package com.xebialabs.deployit.plugin.jbossas.truezip;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class JbossArchivesDriverService extends FsDriverService {
	private final Map<FsScheme, FsDriver> DRIVERS;

	public JbossArchivesDriverService() {
		DRIVERS = newMap(new Object[][] {
				{ "sar", new JarDriver(IOPoolLocator.SINGLETON) },
				{ "rar", new JarDriver(IOPoolLocator.SINGLETON) },
				{ "har", new JarDriver(IOPoolLocator.SINGLETON) },
				{ "aop", new JarDriver(IOPoolLocator.SINGLETON) }
		});
		logger.info("Registering 'sar', 'rar', 'har' and 'aop' as archives available for placeholder replacement.");
	}

	@Override
	public Map<FsScheme, FsDriver> get() {
		return DRIVERS;
	}

	private static final Logger logger = LoggerFactory.getLogger(JbossArchivesDriverService.class);
}
