/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.deployed;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleResourceInspectionStep;
import java.util.Collection;
import java.util.TreeSet;

@Metadata(virtual=true)
public class Resource<D extends Deployable>
extends ProcessedTemplate<D> {
    @Inspect
    public void inspect(InspectionPlanningContext inspectionPlanningContext) {
        inspectionPlanningContext.addStep(new TwiddleResourceInspectionStep(this, "jndiName"));
    }

    public String toLowerHyphen(String string) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, string);
    }

    public String toUpperCamel(String string) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, string);
    }

    public String getTemplate() {
        return this.resolveExpression(super.getTemplate());
    }

    public String getInspectTemplate() {
        String string = (String)this.getProperty("inspectTemplate");
        return this.resolveExpression(string);
    }

    public Collection<String> getParameters() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.type);
        return Sets.newTreeSet((Iterable)Collections2.filter(this.getSyntheticProperties().keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                if (descriptor.getPropertyDescriptor(string).isHidden()) {
                    return false;
                }
                return !string.contains("_");
            }
        }));
    }

    public Collection<ParameterProperty> getParametersProperties() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.type);
        TreeSet treeSet = Sets.newTreeSet((Iterable)Collections2.filter(this.getSyntheticProperties().keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                if (descriptor.getPropertyDescriptor(string).isHidden()) {
                    return false;
                }
                return string.contains("_");
            }
        }));
        return Collections2.transform((Collection)treeSet, (Function)new Function<String, ParameterProperty>(){

            public ParameterProperty apply(String string) {
                String[] stringArray = string.split("_");
                if (stringArray.length != 2) {
                    throw new RuntimeException("Cannot decode " + string);
                }
                String string2 = Resource.this.toLowerHyphen(stringArray[0]);
                String string3 = Resource.this.toLowerHyphen(stringArray[1]).replace('-', '.');
                Object object = Resource.this.getProperty(string);
                return new ParameterProperty(string2, string3, object);
            }
        });
    }

    public class ParameterProperty {
        final String node;
        final String attribute;
        final Object value;

        public ParameterProperty(String string, String string2, Object object) {
            this.node = string;
            this.attribute = string2;
            this.value = object;
        }

        public String getNode() {
            return this.node;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

