/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.PropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.List;
import java.util.Map;

public class TwiddleContainerInspectionStep<T>
extends TwiddleStep
implements InspectionStep {
    private final Map<String, Object> vars = Maps.newHashMap();
    private final PropertyConverter<?> converter;

    public TwiddleContainerInspectionStep(HostContainer hostContainer, String string, String string2, PropertyConverter<?> propertyConverter) {
        super(hostContainer, (String)hostContainer.getProperty("inspectTemplate"));
        this.converter = propertyConverter;
        this.vars.put("container", this.getContainer());
        this.vars.put("mbean", string);
        this.vars.put("attribute", string2);
    }

    public String getDescription() {
        return String.format("Inspect JBoss Server %s/%s", this.vars.get("mbean"), this.vars.get("attribute"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler twiddleProcessOutputHandler) {
        List<String> list = twiddleProcessOutputHandler.getValues();
        if (list.size() > 1) {
            throw new RuntimeException("Too many answers (" + list.size() + ")" + list);
        }
        Object object = this.converter.getConverter().apply((Object)list.iterator().next());
        this.getContainer().setProperty(this.converter.getProperty(), object);
    }
}

