package com.xebialabs.deployit.plugin.jbossas.step;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;

@SuppressWarnings("serial")
public class TwiddleQueryConnectorContainerInspectionStep<T> extends TwiddleStep implements Step {

    private final Map<String, Object> vars = Maps.newHashMap();

    public TwiddleQueryConnectorContainerInspectionStep(Container genericContainer, String expr) {
        super(genericContainer, genericContainer.<String>getProperty("queryTemplate"));
        vars.put("container", genericContainer);
        vars.put("expr", expr);
    }

    @Override
    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return String.format("Query JBoss Server %s", vars.get("expr"));
    }


    @Override
    protected Map<String, Object> getVars() {
        return vars;
    }


    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        for (final String mbean : handler.getValues()) {
            final TwiddleContainerInspectionStep twiddleContainerInspectionStep = new TwiddleContainerInspectionStep(getContainer(), mbean,
                "protocolHandlerClassName port", null) {
                @Override
                protected void doHandle(TwiddleProcessOutputHandler handler) {
                    List<String> values = handler.getValues();
                    if (values.size() != 2) {
                        throw new RuntimeException("Expected number of answer 2, not " + values.size());
                    }
                    String protocol = values.get(0);
                    String port = values.get(1);
                    if (protocol.contains("Ajp")) {
                        getContainer().setProperty("ajpPort", Integer.parseInt(port));
                    } else if (protocol.contains("Http")) {
                        getContainer().setProperty("httpPort", Integer.parseInt(port));
                    }
                }
            };
            try {
                twiddleContainerInspectionStep.execute(ctx);
            } catch (Exception e) {
                throw new RuntimeException("Inspecting " + mbean + " for " + getDescription() + "failed", e);
            }
        }
    }
}


