package com.xebialabs.deployit.plugin.jbossas.container;

import java.io.Serializable;

import com.google.common.base.Function;
import com.google.common.base.Splitter;

import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.ci.Container;


@SuppressWarnings("serial")
@Metadata(description = "Base JBoss Application Server", inspectable = true, virtual = true)
public class BaseServer extends Container {

    @Property(description="JBoss application server installation directory. e.g. /opt/jboss/5.1.0.GA")
    @InspectionProperty
    private String home;

    protected static final Function<String, Integer> DECODE_VERSION = new SerializableFunction<String, Integer>() {
        public Integer apply(String input) {
            if (input.contains(".")) {
                String first = Splitter.on(".").split(input).iterator().next();
                return Integer.parseInt(first);
            }
            throw new RuntimeException("wrong input value " + input);
        }
    };

    protected static final Function<String, String> DECODE_FILE_VALUE = new SerializableFunction<String, String>() {
        public String apply(String input) {
            if (input.contains("file:")) {
                return input.substring(input.indexOf("file:") + "file:".length());
            }
            throw new RuntimeException("wrong input value " + input);
        }
    };

    public String getHome() {
        return home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    private interface SerializableFunction<F, T> extends Function<F,T>, Serializable {}
}