package com.xebialabs.deployit.plugin.jbossas.container;

import com.google.common.base.Functions;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.jbossas.step.SimplePropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleQueryConnectorContainerInspectionStep;

@SuppressWarnings("serial")
@Metadata( description="Jboss 4 application server", inspectable = true)
public class ServerV4 extends BaseServer {

    @SuppressWarnings("rawtypes")
    @Inspect
    public void inspect(InspectionContext ctx) {
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=ServerConfig", "HomeDir", new SimplePropertyConverter<String>("home",
                Functions.<String> identity())));
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=ServerConfig", "ServerName", new SimplePropertyConverter<String>(
                "serverName", Functions.<String> identity())));
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=ServerConfig", "SpecificationVersion",
                new SimplePropertyConverter<Integer>("version", DECODE_VERSION)));
        ctx.addStep(new TwiddleQueryConnectorContainerInspectionStep(this, "jboss.web:type=Connector,*"));
    }

}
