package com.xebialabs.deployit.plugin.jbossas.step;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.overthere.OperatingSystemFamily;

@SuppressWarnings("serial")
public class TwiddleQueryConnectorContainerInspectionStep<T> extends TwiddleStep implements Step {

    private final Map<String, Object> vars = Maps.newHashMap();
    boolean isWindows = getContainer().getHost().getOs() == OperatingSystemFamily.WINDOWS;

    public TwiddleQueryConnectorContainerInspectionStep(Container genericContainer, String expr) {
        super(genericContainer, genericContainer.<String>getProperty("queryTemplate"));
        vars.put("container", genericContainer);
        vars.put("expr", expr);
    }

    @Override
    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return String.format("Query JBoss Server %s", vars.get("expr"));
    }


    @Override
    protected Map<String, Object> getVars() {
        return vars;
    }


    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {

        final List<String> values = handler.getValues();

        if (isWindows) {
            // When the OS is windows the first entry of the list is not usable for discovery
            values.remove(0);
        }

        for (String mbean : values) {
            if (isWindows) {
                // When the OS is windows some escaping needs to be done in order to get the URL in the twiddle command correct
                mbean=mbean.replace("%2F", "%%2F");
            }

            final TwiddleContainerInspectionStep twiddleContainerInspectionStep = new TwiddleContainerInspectionStep(getContainer(), mbean,
                "protocolHandlerClassName port", null) {
                @Override
                protected void doHandle(TwiddleProcessOutputHandler handler) {
                   
                    if (values.size() != 2) {
                        throw new RuntimeException("Expected number of answer 2, not " + values.size());
                    }
                    String protocol = values.get(0);
                    String port = values.get(1);
                    if (protocol.contains("Ajp")) {
                        getContainer().setProperty("ajpPort", Integer.parseInt(port));
                    } else if (protocol.contains("Http")) {
                        getContainer().setProperty("httpPort", Integer.parseInt(port));
                    }
                }
            };
            try {
                twiddleContainerInspectionStep.execute(ctx);
            } catch (Exception e) {
                throw new RuntimeException("Inspecting " + mbean + " for " + getDescription() + "failed", e);
            }
        }
    }
}
