package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;
import java.util.Map;

@SuppressWarnings("serial")
public class TwiddleContainerInspectionStep extends TwiddleStep implements Step {


    private final Map<String, Object> vars = Maps.newHashMap();
    private final PropertyConverter<?> converter;

    public TwiddleContainerInspectionStep(HostContainer deployedJBossResource, String mbean, String attribute, PropertyConverter<?> converter) {
        super(deployedJBossResource, (String) deployedJBossResource.getProperty("inspectTemplate"));
        this.converter = converter;
        vars.put("container", getContainer());
        vars.put("mbean", mbean);
        vars.put("attribute", attribute);
    }

    @Override
    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return String.format("Inspect JBoss Server %s/%s", vars.get("mbean"), vars.get("attribute"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        Iterator<String> values = handler.getValues().iterator();

    	// skip first unusable value on Windows
        if (getContainer().getHost().getOs() == OperatingSystemFamily.WINDOWS) {
            values.next();
        }
    	// only one value allowed!
        String inspectedValue = values.next();
        if (values.hasNext()) {
            throw new RuntimeException("Too many answers (expected 1 element but result was " + handler.getValues() + ")");
    	}

        Object propertyInspectedValue = converter.getConverter().apply(inspectedValue);

        getContainer().setProperty(converter.getProperty(), propertyInspectedValue);
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    private static final Logger logger = LoggerFactory.getLogger(TwiddleContainerInspectionStep.class);
}
