cmd = "/subsystem=datasources/data-source=%s:read-resource" %(deployed.name)
cmd = prependProfilePath(cmd)
ds = executeCmd(cmd)

dsBuilder = DatasourceBuilder(deployed, ds)
inspectCommonDatasourceProperties(dsBuilder)

dsBuilder.addIfNotBlank('newConnectionSql',"new-connection-sql")
dsBuilder.addIfNotBlank('transactionIsolation',"transaction-isolation")
dsBuilder.add('connectionUrl',"connection-url")
dsBuilder.add('useJta',"jta")
dsBuilder.add('useCcm',"use-ccm")

connPropPath = "/subsystem=datasources/data-source=%s/connection-properties" % (deployed.name)
connPropPath = prependProfilePath(connPropPath)
connectionPropertyKeysCmd = 'ls %s' % (connPropPath)
connectionPropKeys = multiSpaceDelimitedLineToList(executeCmd(connectionPropertyKeysCmd))

connProps = deployed.getProperty("connectionProperties")

for k in connectionPropKeys:
	valueCmd = '%s=%s:read-attribute(name=value)' % (connPropPath,k)
	value = executeCmd(valueCmd)
	connProps.put(k,value['result'])
