import re

if re.search(r"\s", deployed.name):
    logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))


appName = getAppInstallName(deployed.name, "war")
uploadedWar = uploadFile(deployed.file, appName)
logOutput("Installing war as %s" % (appName))

commandString = 'deploy %s %s' % (uploadedWar.path, targetServerGroups())
if (deployed.getProperty("contextRoot")):
    commandString += " --runtime-name=%s.war" % deployed.getProperty("contextRoot")
else:
    logOutput("Going to use deployed name for context root")
    commandString += " --runtime-name=%s.war" % deployed.name

errMsg = executeCmd(commandString)
if errMsg:
    logErrorAndExit(errMsg)
logOutput("Done.")
