/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.controltask.ControlTaskDispatcher;
import com.xebialabs.deployit.plugin.jbossdm.deployed.DeltaWrapper;
import com.xebialabs.deployit.plugin.jbossdm.step.BaseStep;
import com.xebialabs.deployit.plugin.jbossdm.step.CliInspectionStep;
import com.xebialabs.deployit.plugin.jbossdm.step.StepFactory;
import java.util.HashMap;
import java.util.List;

@Metadata(virtual=true, description="Base for all deployed that utilize the JBoss Cli for configuration")
public class CliManagedDeployed<D extends Deployable, C extends CliManagedContainer>
extends BaseDeployed<D, C> {
    @Property(hidden=true, defaultValue="60", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="60", description="The order of the step in the step list for the modify operation.")
    private int modifyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the noop operation.")
    private int noopOrder;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String noopVerb;
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the noop operation.")
    private String noopScript;
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="List of python library scripts that should be automatically loaded when using a JBoss CLI script.")
    private List<String> libraries = Lists.newArrayList();

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta) {
        return this.addStep(stepFactory, ctx, script, order, verb, delta, true);
    }

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta, boolean checkpoint) {
        return this.addStep(stepFactory, ctx, script, order, verb, delta, checkpoint, delta.getOperation());
    }

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta, boolean checkpoint, Operation operation) {
        if (!Strings.nullToEmpty((String)script).trim().isEmpty()) {
            HashMap<String, Object> pyCtx = this.createPythonVars();
            pyCtx.put("delta", new DeltaWrapper(delta));
            pyCtx.put("deployedApplication", ctx.getDeployedApplication());
            BaseStep step = stepFactory.withLibraries(this.libraries).createStep(script, order, pyCtx, this.getDescription(verb), (CliManagedContainer)this.getContainer());
            if (checkpoint) {
                ctx.addStepWithCheckpoint((Step)step, delta, operation);
            } else {
                ctx.addStep((Step)step);
            }
            return true;
        }
        return false;
    }

    protected HashMap<String, Object> createPythonVars() {
        HashMap pyCtx = Maps.newHashMap();
        pyCtx.put("deployed", this);
        pyCtx.put("container", this.getContainer());
        return pyCtx;
    }

    public List<Step> controlTaskDispatch(String name) {
        return ControlTaskDispatcher.dispatch(name, (ConfigurationItem)this);
    }

    public String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((CliManagedContainer)this.getContainer()).getName());
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        if (!Strings.nullToEmpty((String)this.getInspectScript()).trim().isEmpty()) {
            String desc = "Inspect " + this.getName() + " in container " + ((CliManagedContainer)this.getContainer()).getId();
            CliInspectionStep step = new CliInspectionStep(this.getInspectScript(), 0, this.createPythonVars(), desc, (CliManagedContainer)this.getContainer());
            step.setAdditionalLibraries(this.libraries);
            ctx.addStep((Step)step);
        }
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        this.executeCreateWithFactory(StepFactory.deploymentStepFactory(), ctx, delta);
    }

    protected void executeCreateWithFactory(StepFactory stepFactory, DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        deployed.addStep(stepFactory, ctx, this.getCreateScript(), this.getCreateOrder(), this.getCreateVerb(), delta, true, Operation.CREATE);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getPrevious();
        deployed.addStep(StepFactory.deploymentStepFactory(), ctx, this.getDestroyScript(), this.getDestroyOrder(), this.getDestroyVerb(), delta, true, Operation.DESTROY);
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        deployed.addStep(StepFactory.deploymentStepFactory(), ctx, this.getNoopScript(), this.getNoopOrder(), this.getNoopVerb(), delta, false);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        this.executeModifyWithFactory(StepFactory.deploymentStepFactory(), ctx, delta);
    }

    protected void executeModifyWithFactory(StepFactory stepFactory, DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        if (!deployed.addStep(stepFactory, ctx, this.getModifyScript(), this.getModifyOrder(), this.getModifyVerb(), delta)) {
            CliManagedDeployed previousDeployed = (CliManagedDeployed)delta.getPrevious();
            previousDeployed.executeDestroy(ctx, delta);
            deployed.executeCreate(ctx, delta);
        }
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<String> libraries) {
        this.libraries = libraries;
    }

    public String getCreateScript() {
        return this.createScript;
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }

    public String getNoopScript() {
        return this.noopScript;
    }

    public void setNoopScript(String noopScript) {
        this.noopScript = noopScript;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    public int getNoopOrder() {
        return this.noopOrder;
    }

    public void setNoopOrder(int noopOrder) {
        this.noopOrder = noopOrder;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public void setCreateVerb(String createVerb) {
        this.createVerb = createVerb;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public void setModifyVerb(String modifyVerb) {
        this.modifyVerb = modifyVerb;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public void setDestroyVerb(String destroyVerb) {
        this.destroyVerb = destroyVerb;
    }

    public String getNoopVerb() {
        return this.noopVerb;
    }

    public void setNoopVerb(String noopVerb) {
        this.noopVerb = noopVerb;
    }

    public String getInspectScript() {
        return this.inspectScript;
    }

    public void setInspectScript(String inspectScript) {
        this.inspectScript = inspectScript;
    }
}

